/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.batch;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.eval.AbstractProfiler;
import org.apache.tika.eval.ExtractProfiler;
import org.apache.tika.eval.batch.DBConsumersManager;
import org.apache.tika.eval.batch.EvalConsumerBuilder;
import org.apache.tika.eval.db.TableInfo;
import org.apache.tika.util.PropsUtil;

public class ExtractProfilerBuilder
extends EvalConsumerBuilder {
    public static final String TABLE_PREFIX_KEY = "tablePrefix";
    private final List<TableInfo> tableInfos;
    private final List<TableInfo> refTableInfos;

    public ExtractProfilerBuilder() {
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        tableInfos.add(AbstractProfiler.MIME_TABLE);
        tableInfos.add(ExtractProfiler.CONTAINER_TABLE);
        tableInfos.add(ExtractProfiler.PROFILE_TABLE);
        tableInfos.add(ExtractProfiler.EXTRACT_EXCEPTION_TABLE);
        tableInfos.add(ExtractProfiler.EXCEPTION_TABLE);
        tableInfos.add(ExtractProfiler.CONTENTS_TABLE);
        tableInfos.add(ExtractProfiler.EMBEDDED_FILE_PATH_TABLE);
        this.tableInfos = Collections.unmodifiableList(tableInfos);
        ArrayList<TableInfo> refTableInfos = new ArrayList<TableInfo>();
        refTableInfos.add(AbstractProfiler.REF_PARSE_ERROR_TYPES);
        refTableInfos.add(AbstractProfiler.REF_PARSE_EXCEPTION_TYPES);
        refTableInfos.add(AbstractProfiler.REF_EXTRACT_EXCEPTION_TYPES);
        this.refTableInfos = Collections.unmodifiableList(refTableInfos);
    }

    @Override
    public FileResourceConsumer build() throws IOException, SQLException {
        Path extracts = PropsUtil.getPath((String)this.localAttrs.get("extracts"), null);
        if (extracts == null) {
            throw new RuntimeException("Must specify \"extracts\" -- directory to crawl");
        }
        if (!Files.isDirectory(extracts, new LinkOption[0])) {
            throw new RuntimeException("ROOT DIRECTORY DOES NOT EXIST: " + extracts.toAbsolutePath());
        }
        Path inputDir = PropsUtil.getPath((String)this.localAttrs.get("inputDir"), null);
        if (inputDir == null) {
            throw new RuntimeException("Must specify -inputDir");
        }
        if (extracts == null && inputDir != null) {
            extracts = inputDir;
        }
        return this.parameterizeProfiler(new ExtractProfiler(this.queue, inputDir, extracts, this.buildExtractReader(this.localAttrs), this.getDBWriter(this.tableInfos)));
    }

    @Override
    protected void updateTableInfosWithPrefixes(Map<String, String> attrs) {
        String tableNamePrefix = attrs.get(TABLE_PREFIX_KEY);
        if (tableNamePrefix != null && !tableNamePrefix.equals("null")) {
            for (TableInfo tableInfo : this.tableInfos) {
                tableInfo.setNamePrefix(tableNamePrefix);
            }
        }
    }

    @Override
    protected List<TableInfo> getRefTableInfos() {
        return this.refTableInfos;
    }

    @Override
    protected List<TableInfo> getNonRefTableInfos() {
        return this.tableInfos;
    }

    @Override
    protected void addErrorLogTablePairs(DBConsumersManager manager) {
        Path errorLog = PropsUtil.getPath((String)this.localAttrs.get("errorLogFile"), null);
        if (errorLog == null) {
            return;
        }
        manager.addErrorLogTablePair(errorLog, ExtractProfiler.EXTRACT_EXCEPTION_TABLE);
    }
}

