/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import org.apache.lucene.analysis.icu.segmentation.CharArrayIterator;

final class BreakIteratorWrapper {
    private final CharArrayIterator textIterator = new CharArrayIterator();
    private final RuleBasedBreakIterator rbbi;
    private char[] text;
    private int start;
    private int status;
    static final UnicodeSet EMOJI_RK = new UnicodeSet("[*#0-9\u00a9\u00ae\u2122\u3030\u303d]").freeze();

    BreakIteratorWrapper(RuleBasedBreakIterator rbbi) {
        this.rbbi = rbbi;
    }

    int current() {
        return this.rbbi.current();
    }

    int getRuleStatus() {
        return this.status;
    }

    int next() {
        int current = this.rbbi.current();
        int next = this.rbbi.next();
        this.status = this.calcStatus(current, next);
        return next;
    }

    private int calcStatus(int current, int next) {
        if (next != -1 && this.isEmoji(current, next)) {
            return 299;
        }
        return this.rbbi.getRuleStatus();
    }

    private boolean isEmoji(int current, int next) {
        int end = this.start + next;
        int begin = this.start + current;
        int codepoint = UTF16.charAt(this.text, 0, end, begin);
        if (UCharacter.hasBinaryProperty(codepoint, 57)) {
            if (EMOJI_RK.contains(codepoint)) {
                int trailer = begin + Character.charCount(codepoint);
                return trailer < end && (this.text[trailer] == '\ufe0f' || this.text[trailer] == '\u20e3');
            }
            return true;
        }
        return false;
    }

    void setText(char[] text, int start, int length) {
        this.text = text;
        this.start = start;
        this.textIterator.setText(text, start, length);
        this.rbbi.setText(this.textIterator);
        this.status = 0;
    }
}

