/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.TextTrieMap;
import com.ibm.icu.impl.number.parse.NumberParseMatcher;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.Iterator;

public class CurrencyTrieMatcher
implements NumberParseMatcher {
    private final TextTrieMap<Currency.CurrencyStringInfo> longNameTrie;
    private final TextTrieMap<Currency.CurrencyStringInfo> symbolTrie;

    public static CurrencyTrieMatcher getInstance(ULocale locale) {
        return new CurrencyTrieMatcher(locale);
    }

    private CurrencyTrieMatcher(ULocale locale) {
        this.longNameTrie = Currency.getParsingTrie(locale, 1);
        this.symbolTrie = Currency.getParsingTrie(locale, 0);
    }

    @Override
    public boolean match(StringSegment segment, ParsedNumber result) {
        if (result.currencyCode != null) {
            return false;
        }
        TextTrieMap.Output trieOutput = new TextTrieMap.Output();
        Iterator<Currency.CurrencyStringInfo> values = this.longNameTrie.get(segment, 0, trieOutput);
        if (values == null) {
            values = this.symbolTrie.get(segment, 0, trieOutput);
        }
        if (values != null) {
            result.currencyCode = values.next().getISOCode();
            segment.adjustOffset(trieOutput.matchLength);
            result.setCharsConsumed(segment);
        }
        return trieOutput.partialMatch;
    }

    @Override
    public UnicodeSet getLeadCodePoints() {
        UnicodeSet leadCodePoints = new UnicodeSet();
        this.longNameTrie.putLeadCodePoints(leadCodePoints);
        this.symbolTrie.putLeadCodePoints(leadCodePoints);
        return leadCodePoints.freeze();
    }

    @Override
    public void postProcess(ParsedNumber result) {
    }

    public String toString() {
        return "<CurrencyTrieMatcher>";
    }
}

