/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.rest;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.support.healthcheck.SupportHealthCheckModuleDescriptorNotFoundException;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import com.atlassian.support.healthcheck.impl.Pair;
import com.atlassian.support.healthcheck.impl.SupportHealthCheckManager;
import com.atlassian.support.healthcheck.rest.HealthCheckRepresentation;
import com.atlassian.support.healthcheck.rest.HealthCheckRepresentations;
import com.atlassian.support.healthcheck.rest.HealthCheckStatusesRepresentation;
import com.atlassian.support.healthcheck.rest.HealthStatusRepresentation;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/xml", "application/json"})
public class HealthCheckResource {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckResource.class);
    private static final Response KEYS_TAGS_BAD_REQUEST_RESPONSE = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Providing both key/s and tag/s is not valid. Please provide one or the other.").build();
    private final SupportHealthCheckManager healthCheckManager;
    private final UserManager userManager;

    public HealthCheckResource(SupportHealthCheckManager healthCheckManager, UserManager userManager) {
        this.healthCheckManager = healthCheckManager;
        this.userManager = userManager;
    }

    @Path(value="/check")
    @GET
    public Response check() {
        this.checkIfAdmin();
        Collection<Pair<ExtendedSupportHealthCheck, SupportHealthStatus>> statuses = this.healthCheckManager.performAllChecks();
        ArrayList<HealthStatusRepresentation> failures = new ArrayList<HealthStatusRepresentation>();
        for (Pair<ExtendedSupportHealthCheck, SupportHealthStatus> status : statuses) {
            if (status.getRight().isHealthy()) continue;
            failures.add(this.statusToStatusRepresentation(status));
        }
        if (failures.isEmpty()) {
            return Response.noContent().build();
        }
        HealthCheckStatusesRepresentation healthCheck = new HealthCheckStatusesRepresentation(failures);
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)healthCheck).build();
    }

    @Path(value="/checkDetails")
    @GET
    public Response checkDetails(@QueryParam(value="key") Set<String> healthCheckKeys) {
        Collection<Pair<ExtendedSupportHealthCheck, SupportHealthStatus>> statuses;
        this.checkIfAdmin();
        if (this.isKeysAndTagsDefined(healthCheckKeys)) {
            return KEYS_TAGS_BAD_REQUEST_RESPONSE;
        }
        if (healthCheckKeys != null && !healthCheckKeys.isEmpty()) {
            try {
                statuses = this.healthCheckManager.performChecksWithKeys(healthCheckKeys);
            }
            catch (SupportHealthCheckModuleDescriptorNotFoundException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Health check module descriptor with key '%s' was not found.", e.getUnfoundKey())).build();
            }
        } else {
            statuses = this.healthCheckManager.performAllChecks();
        }
        ArrayList<HealthStatusRepresentation> statusRepresentations = new ArrayList<HealthStatusRepresentation>(statuses.size());
        boolean isHealthy = true;
        for (Pair<ExtendedSupportHealthCheck, SupportHealthStatus> status : statuses) {
            isHealthy &= status.getRight().isHealthy();
            statusRepresentations.add(this.statusToStatusRepresentation(status));
        }
        HealthCheckStatusesRepresentation healthCheckStatusList = new HealthCheckStatusesRepresentation(statusRepresentations);
        if (isHealthy) {
            return Response.ok((Object)healthCheckStatusList).build();
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)healthCheckStatusList).build();
    }

    @Path(value="/list")
    @GET
    public Response list() {
        this.checkIfAdmin();
        Collection<ExtendedSupportHealthCheck> healthChecks = this.healthCheckManager.getHealthChecks();
        return Response.ok((Object)new HealthCheckRepresentations(this.checksToCheckRepresentations(healthChecks))).build();
    }

    private void checkIfAdmin() {
        String userName = this.userManager.getRemoteUsername();
        if (userName == null || !this.userManager.isAdmin(userName)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private HealthStatusRepresentation statusToStatusRepresentation(Pair<ExtendedSupportHealthCheck, SupportHealthStatus> entry) {
        ExtendedSupportHealthCheck healthCheck = entry.getLeft();
        SupportHealthStatus status = entry.getRight();
        return new HealthStatusRepresentation(healthCheck.getName(), healthCheck.getDescription(), status.isHealthy(), status.failureReason(), status.getApplication().name(), status.getTime(), status.getSeverity(), status.getDocumentation(), healthCheck.getTag());
    }

    private Collection<HealthCheckRepresentation> checksToCheckRepresentations(Collection<ExtendedSupportHealthCheck> healthChecks) {
        return Collections2.transform(healthChecks, (Function)new Function<ExtendedSupportHealthCheck, HealthCheckRepresentation>(){

            public HealthCheckRepresentation apply(ExtendedSupportHealthCheck healthCheck) {
                return new HealthCheckRepresentation(healthCheck.getName(), healthCheck.getDescription(), healthCheck.getKey(), healthCheck.getTimeOut(), healthCheck.getTag());
            }
        });
    }

    private boolean isKeysAndTagsDefined(Set<String> keys) {
        return keys != null && !keys.isEmpty();
    }
}

