/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.SupportHealthCheckCondition;
import com.atlassian.support.healthcheck.SupportHealthCheckModuleDescriptor;
import com.atlassian.support.healthcheck.SupportHealthCheckModuleDescriptorNotFoundException;
import com.atlassian.support.healthcheck.SupportHealthCheckSupplier;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import com.atlassian.support.healthcheck.impl.PluginSuppliedSupportHealthCheck;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSupportHealthCheckSupplier
implements SupportHealthCheckSupplier {
    private static final Logger log = LoggerFactory.getLogger(DefaultSupportHealthCheckSupplier.class);
    private final PluginAccessor pluginAccessor;
    private final I18nResolver i18nResolver;

    public DefaultSupportHealthCheckSupplier(PluginAccessor pluginAccessor, I18nResolver i18nResolver) {
        this.pluginAccessor = pluginAccessor;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public Collection<ExtendedSupportHealthCheck> getHealthChecks() {
        return this.healthChecksFrom(this.pluginAccessor.getEnabledModuleDescriptorsByClass(SupportHealthCheckModuleDescriptor.class));
    }

    @Override
    public Collection<ExtendedSupportHealthCheck> getHealthChecksWithKeys(Set<String> keys) throws SupportHealthCheckModuleDescriptorNotFoundException {
        return this.healthChecksFrom(this.getSupportHealthCheckModuleDescriptorsWithKeys(keys));
    }

    private Collection<SupportHealthCheckModuleDescriptor> getSupportHealthCheckModuleDescriptorsWithKeys(Set<String> keys) throws SupportHealthCheckModuleDescriptorNotFoundException {
        ArrayList<SupportHealthCheckModuleDescriptor> healthCheckDescriptors = new ArrayList<SupportHealthCheckModuleDescriptor>(keys.size());
        for (String healthCheckKey : keys) {
            try {
                SupportHealthCheckModuleDescriptor enabledPluginModule = (SupportHealthCheckModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(healthCheckKey);
                if (enabledPluginModule == null) {
                    throw new SupportHealthCheckModuleDescriptorNotFoundException(healthCheckKey);
                }
                healthCheckDescriptors.add(enabledPluginModule);
            }
            catch (IllegalArgumentException e) {
                throw new SupportHealthCheckModuleDescriptorNotFoundException(healthCheckKey, e);
            }
        }
        return healthCheckDescriptors;
    }

    private Collection<ExtendedSupportHealthCheck> healthChecksFrom(Collection<SupportHealthCheckModuleDescriptor> healthCheckDescriptors) {
        return Collections2.filter((Collection)Collections2.transform(healthCheckDescriptors, (Function)new Function<SupportHealthCheckModuleDescriptor, ExtendedSupportHealthCheck>(){

            public ExtendedSupportHealthCheck apply(@Nullable SupportHealthCheckModuleDescriptor md) {
                if (md != null && DefaultSupportHealthCheckSupplier.shouldDisplay(md.getConditions())) {
                    log.debug("Supplying health check from descriptor: {}", (Object)md);
                    return new PluginSuppliedSupportHealthCheck(md.getModule(), md.getCompleteKey(), DefaultSupportHealthCheckSupplier.this.getText(md.getName()), DefaultSupportHealthCheckSupplier.this.getText(md.getDescription()), md.getTimeOut(), DefaultSupportHealthCheckSupplier.this.getText(md.getTag()));
                }
                return null;
            }
        }), (Predicate)new Predicate<ExtendedSupportHealthCheck>(){

            public boolean apply(ExtendedSupportHealthCheck check) {
                return check != null;
            }
        });
    }

    private static boolean shouldDisplay(List<SupportHealthCheckCondition> conditions) {
        for (SupportHealthCheckCondition condition : conditions) {
            if (condition.shouldDisplay()) continue;
            return false;
        }
        return true;
    }

    private String getText(String name) {
        return name == null ? null : this.i18nResolver.getText(name);
    }
}

