/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.util.Formatter;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.Resource;

public final class LocationImpl
implements Location {
    private final Resource resource;
    private final int line;
    private final int column;
    private static final int UNKNOWN = -1;

    public LocationImpl(Resource resource) {
        this(resource, -1);
    }

    public LocationImpl(Resource resource, int line) {
        this(resource, line, -1);
    }

    public LocationImpl(Resource resource, int line, int column) {
        this.resource = resource;
        this.line = line;
        this.column = column;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.resource.toString());
        Formatter formatter = new Formatter(buffer);
        if (this.line != -1) {
            formatter.format(", line %d", this.line);
        }
        if (this.column != -1) {
            formatter.format(", column %d", this.column);
        }
        return buffer.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.line;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationImpl other = (LocationImpl)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }
}

