/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.bindings;

import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.beanmodel.PropertyConduit;
import org.apache.tapestry5.beanmodel.services.PropertyConduitSource;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.internal.services.StringInterner;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.internal.bindings.PropBinding;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.BindingFactory;
import org.apache.tapestry5.services.pageload.PageClassLoaderContext;
import org.apache.tapestry5.services.pageload.PageClassLoaderContextManager;

public class PropBindingFactory
implements BindingFactory {
    private final PropertyConduitSource source;
    private final StringInterner interner;
    private final PageClassLoaderContextManager pageClassLoaderContextManager;

    public PropBindingFactory(PropertyConduitSource propertyConduitSource, StringInterner interner, PageClassLoaderContextManager pageClassLoaderContextManager) {
        this.source = propertyConduitSource;
        this.interner = interner;
        this.pageClassLoaderContextManager = pageClassLoaderContextManager;
    }

    @Override
    public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
        Component target = container.getComponent();
        Class targetClass = target.getClass();
        targetClass = this.getClassLoaderAppropriateClass(targetClass);
        PropertyConduit conduit = this.source.create(targetClass, expression);
        String toString = this.interner.format("PropBinding[%s %s(%s)]", new Object[]{description, container.getCompleteId(), expression});
        return new PropBinding(location, target, conduit, expression, toString);
    }

    private Class getClassLoaderAppropriateClass(Class targetClass) {
        String className = targetClass.getName();
        try {
            PageClassLoaderContext context = this.pageClassLoaderContextManager.get(className);
            targetClass = context.getProxyFactory().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new TapestryException(e.getMessage(), (Throwable)e);
        }
        return targetClass;
    }
}

