/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.commons.MessageFormatter;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.javascript.DataConstants;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.validator.AbstractValidator;

public class Regexp
extends AbstractValidator<Pattern, String> {
    public Regexp(JavaScriptSupport javaScriptSupport) {
        super(Pattern.class, String.class, "regexp", javaScriptSupport);
    }

    private String buildMessage(MessageFormatter formatter, Field field, Pattern constraintValue) {
        return formatter.format(new Object[]{constraintValue.toString(), field.getLabel()});
    }

    @Override
    public void render(Field field, Pattern constraintValue, MessageFormatter formatter, MarkupWriter writer, FormSupport formSupport) {
        String message = this.buildMessage(formatter, field, constraintValue);
        if (formSupport.isClientValidationEnabled()) {
            this.javaScriptSupport.require("t5/core/validation");
            writer.attributes(DataConstants.VALIDATION_ATTRIBUTE, true, "data-validate-regexp", constraintValue.pattern(), "data-regexp-message", message, "pattern", constraintValue.pattern(), "title", message);
        }
    }

    @Override
    public void validate(Field field, Pattern constraintValue, MessageFormatter formatter, String value) throws ValidationException {
        Matcher matcher = constraintValue.matcher(value);
        if (!matcher.matches()) {
            throw new ValidationException(this.buildMessage(formatter, field, constraintValue));
        }
    }
}

