/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.modules;

import java.util.Locale;
import org.apache.tapestry5.BooleanHook;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.OrderedConfiguration;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.corelib.components.FontAwesomeIcon;
import org.apache.tapestry5.corelib.components.Glyphicon;
import org.apache.tapestry5.http.services.Dispatcher;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.ajax.JavaScriptSupportImpl;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.services.javascript.AddBrowserCompatibilityStyles;
import org.apache.tapestry5.internal.services.javascript.ConfigureHTMLElementFilter;
import org.apache.tapestry5.internal.services.javascript.Internal;
import org.apache.tapestry5.internal.services.javascript.JavaScriptStackPathConstructor;
import org.apache.tapestry5.internal.services.javascript.JavaScriptStackSourceImpl;
import org.apache.tapestry5.internal.services.javascript.ModuleDispatcher;
import org.apache.tapestry5.internal.services.javascript.ModuleManagerImpl;
import org.apache.tapestry5.internal.util.MessageCatalogResource;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.FactoryDefaults;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.ioc.util.IdAllocator;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentOverride;
import org.apache.tapestry5.services.Core;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.EnvironmentalShadowBuilder;
import org.apache.tapestry5.services.LocalizationSetter;
import org.apache.tapestry5.services.MarkupRenderer;
import org.apache.tapestry5.services.MarkupRendererFilter;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.PartialMarkupRendererFilter;
import org.apache.tapestry5.services.PathConstructor;
import org.apache.tapestry5.services.compatibility.Compatibility;
import org.apache.tapestry5.services.compatibility.Trait;
import org.apache.tapestry5.services.javascript.AMDWrapper;
import org.apache.tapestry5.services.javascript.ExtensibleJavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptModuleConfiguration;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.services.javascript.ModuleManager;
import org.apache.tapestry5.services.javascript.StackExtension;
import org.apache.tapestry5.services.javascript.StackExtensionType;
import org.apache.tapestry5.services.messages.ComponentMessagesSource;

public class JavaScriptModule {
    private static final String ROOT = "${tapestry.asset.root}";
    private final Environment environment;
    private final EnvironmentalShadowBuilder environmentalBuilder;
    private static final String[] bundledModules = new String[]{"alert", "ajax", "bootstrap", "console", "dom", "events", "exception-frame", "fields", "forms", "pageinit", "messages", "utils", "validation"};

    public JavaScriptModule(Environment environment, EnvironmentalShadowBuilder environmentalBuilder) {
        this.environment = environment;
        this.environmentalBuilder = environmentalBuilder;
    }

    public static void bind(ServiceBinder binder) {
        binder.bind(ModuleManager.class, ModuleManagerImpl.class);
        binder.bind(JavaScriptStackSource.class, JavaScriptStackSourceImpl.class);
        binder.bind(JavaScriptStack.class, ExtensibleJavaScriptStack.class).withMarker(new Class[]{Core.class}).withId("CoreJavaScriptStack");
        binder.bind(JavaScriptStack.class, ExtensibleJavaScriptStack.class).withMarker(new Class[]{Internal.class}).withId("InternalJavaScriptStack");
    }

    @Contribute(value=JavaScriptStackSource.class)
    public static void provideBuiltinJavaScriptStacks(MappedConfiguration<String, JavaScriptStack> configuration, @Core JavaScriptStack coreStack, @Internal JavaScriptStack internalStack) {
        configuration.add((Object)"core", (Object)coreStack);
        configuration.add((Object)"internal", (Object)internalStack);
    }

    @Contribute(value=JavaScriptStack.class)
    @Core
    public static void setupCoreJavaScriptStack(OrderedConfiguration<StackExtension> configuration, Compatibility compatibility, @Symbol(value="tapestry.javascript-infrastructure-provider") String provider) {
        configuration.add("requirejs", (Object)StackExtension.library("${tapestry.asset.root}/require.js"), new String[0]);
        configuration.add("underscore-library", (Object)StackExtension.library("${tapestry.asset.root}/underscore-1.8.3.js"), new String[0]);
        if (provider.equals("prototype")) {
            String SCRIPTY = "${tapestry.scriptaculous}";
            JavaScriptModule.add(configuration, StackExtensionType.LIBRARY, "${tapestry.scriptaculous}/prototype.js");
            if (compatibility.enabled(Trait.SCRIPTACULOUS)) {
                JavaScriptModule.add(configuration, StackExtensionType.LIBRARY, "${tapestry.scriptaculous}/scriptaculous.js", "${tapestry.scriptaculous}/effects.js");
            }
        }
        if (compatibility.enabled(Trait.INITIALIZERS)) {
            JavaScriptModule.add(configuration, StackExtensionType.LIBRARY, "${tapestry.asset.root}/t53-compatibility.js");
            configuration.add("t5/core/init", (Object)new StackExtension(StackExtensionType.MODULE, "t5/core/init"), new String[0]);
        }
        configuration.add("jquery-library", (Object)StackExtension.library("${tapestry.asset.root}/jquery.js"), new String[0]);
        if (provider.equals("prototype")) {
            configuration.add("jquery-noconflict", (Object)StackExtension.library("${tapestry.asset.root}/jquery-noconflict.js"), new String[0]);
        }
        JavaScriptModule.add(configuration, StackExtensionType.MODULE, "jquery");
        JavaScriptModule.add(configuration, StackExtensionType.STYLESHEET, "${tapestry.font-awesome-root}/css/font-awesome.css");
        if (compatibility.enabled(Trait.BOOTSTRAP_3) && compatibility.enabled(Trait.BOOTSTRAP_4)) {
            throw new RuntimeException("You cannot have Trait.BOOTSTRAP_3 and Trait.BOOTSTRAP_4 enabled at the same time. Check your contributions to the Compatibility service.");
        }
        if (compatibility.enabled(Trait.BOOTSTRAP_3)) {
            JavaScriptModule.addCoreStylesheets(configuration, "${tapestry.bootstrap-root}/css/bootstrap.css");
        }
        if (compatibility.enabled(Trait.BOOTSTRAP_4)) {
            JavaScriptModule.addCoreStylesheets(configuration, "${tapestry.bootstrap-root}/css/bootstrap.css");
            JavaScriptModule.add(configuration, StackExtensionType.STYLESHEET, "${tapestry.bootstrap-root}/css/bootstrap-grid.css");
        }
        if (!compatibility.enabled(Trait.BOOTSTRAP_3) && !compatibility.enabled(Trait.BOOTSTRAP_4)) {
            configuration.add("defaultcss", (Object)StackExtension.stylesheet("${tapestry.default-stylesheet}"), new String[0]);
        }
        for (String name : bundledModules) {
            String full = "t5/core/" + name;
            configuration.add(full, (Object)StackExtension.module(full), new String[0]);
        }
        configuration.add("underscore-module", (Object)StackExtension.module("underscore"), new String[0]);
    }

    @Contribute(value=Compatibility.class)
    public static void setupCompatibilityDefaults(MappedConfiguration<Trait, Boolean> configuration) {
        configuration.add((Object)Trait.BOOTSTRAP_4, (Object)false);
    }

    @Contribute(value=JavaScriptStack.class)
    @Internal
    public static void setupInternalJavaScriptStack(OrderedConfiguration<StackExtension> configuration) {
        JavaScriptModule.addCoreStylesheets(configuration, "${tapestry.asset.root}/bootstrap/css/bootstrap.css");
    }

    private static void addCoreStylesheets(OrderedConfiguration<StackExtension> configuration, String bootstrapPath) {
        JavaScriptModule.add(configuration, StackExtensionType.STYLESHEET, bootstrapPath, "${tapestry.asset.root}/tapestry.css", "${tapestry.asset.root}/exception-frame.css", "${tapestry.asset.root}/tapestry-console.css", "${tapestry.asset.root}/tree.css");
    }

    private static void add(OrderedConfiguration<StackExtension> configuration, StackExtensionType type, String ... paths) {
        for (String path : paths) {
            int slashx = path.lastIndexOf(47);
            String id = path.substring(slashx + 1);
            configuration.add(id, (Object)new StackExtension(type, path), new String[0]);
        }
    }

    public JavaScriptSupport buildJavaScriptSupport() {
        return this.environmentalBuilder.build(JavaScriptSupport.class);
    }

    @Contribute(value=Dispatcher.class)
    @Primary
    public static void setupModuleDispatchers(OrderedConfiguration<Dispatcher> configuration, ModuleManager moduleManager, OperationTracker tracker, ResourceStreamer resourceStreamer, PathConstructor pathConstructor, JavaScriptStackSource javaScriptStackSource, JavaScriptStackPathConstructor javaScriptStackPathConstructor, LocalizationSetter localizationSetter, @Symbol(value="tapestry.module-path-prefix") String modulePathPrefix, @Symbol(value="tapestry.asset-path-prefix") String assetPathPrefix) {
        configuration.add("Modules", (Object)new ModuleDispatcher(moduleManager, resourceStreamer, tracker, pathConstructor, javaScriptStackSource, javaScriptStackPathConstructor, localizationSetter, modulePathPrefix, assetPathPrefix, false), new String[]{"after:Asset", "before:ComponentEvent"});
        configuration.add("ComnpressedModules", (Object)new ModuleDispatcher(moduleManager, resourceStreamer, tracker, pathConstructor, javaScriptStackSource, javaScriptStackPathConstructor, localizationSetter, modulePathPrefix, assetPathPrefix, true), new String[]{"after:Modules", "before:ComponentEvent"});
    }

    @Contribute(value=MarkupRenderer.class)
    public void exposeJavaScriptSupportForFullPageRenders(OrderedConfiguration<MarkupRendererFilter> configuration, final JavaScriptStackSource javascriptStackSource, final JavaScriptStackPathConstructor javascriptStackPathConstructor, Request request) {
        final BooleanHook suppressCoreStylesheetsHook = this.createSuppressCoreStylesheetHook(request);
        MarkupRendererFilter javaScriptSupport = new MarkupRendererFilter(){

            @Override
            public void renderMarkup(MarkupWriter writer, MarkupRenderer renderer) {
                DocumentLinker linker = JavaScriptModule.this.environment.peekRequired(DocumentLinker.class);
                JavaScriptSupportImpl support = new JavaScriptSupportImpl(linker, javascriptStackSource, javascriptStackPathConstructor, suppressCoreStylesheetsHook);
                JavaScriptModule.this.environment.push(JavaScriptSupport.class, support);
                renderer.renderMarkup(writer);
                JavaScriptModule.this.environment.pop(JavaScriptSupport.class);
                support.commit();
            }
        };
        configuration.add("JavaScriptSupport", (Object)javaScriptSupport, new String[]{"after:DocumentLinker"});
    }

    @Contribute(value=PartialMarkupRenderer.class)
    public void exposeJavaScriptSupportForPartialPageRender(OrderedConfiguration<PartialMarkupRendererFilter> configuration, final JavaScriptStackSource javascriptStackSource, final JavaScriptStackPathConstructor javascriptStackPathConstructor, final Request request) {
        final BooleanHook suppressCoreStylesheetsHook = this.createSuppressCoreStylesheetHook(request);
        PartialMarkupRendererFilter javascriptSupport = new PartialMarkupRendererFilter(){

            @Override
            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer renderer) {
                IdAllocator idAllocator;
                if (request.getParameter("t:suppress-namespaced-ids") == null) {
                    String uid = Long.toHexString(System.nanoTime());
                    String namespace = "_" + uid;
                    idAllocator = new IdAllocator(namespace);
                } else {
                    idAllocator = new IdAllocator();
                }
                DocumentLinker linker = JavaScriptModule.this.environment.peekRequired(DocumentLinker.class);
                JavaScriptSupportImpl support = new JavaScriptSupportImpl(linker, javascriptStackSource, javascriptStackPathConstructor, idAllocator, true, suppressCoreStylesheetsHook);
                JavaScriptModule.this.environment.push(JavaScriptSupport.class, support);
                renderer.renderMarkup(writer, reply);
                JavaScriptModule.this.environment.pop(JavaScriptSupport.class);
                support.commit();
            }
        };
        configuration.add("JavaScriptSupport", (Object)javascriptSupport, new String[]{"after:DocumentLinker"});
    }

    private BooleanHook createSuppressCoreStylesheetHook(final Request request) {
        return new BooleanHook(){

            @Override
            public boolean checkHook() {
                return request.getAttribute("tapestry.suppress-core-stylesheets") != null;
            }
        };
    }

    @Contribute(value=ModuleManager.class)
    public static void setupBaseModules(MappedConfiguration<String, Object> configuration, @Path(value="${tapestry.asset.root}/underscore-shim.js") Resource underscoreShim, @Path(value="${tapestry.asset.root}/jquery-shim.js") Resource jqueryShim, @Path(value="${tapestry.asset.root}/typeahead.js") Resource typeahead, @Path(value="${tapestry.asset.root}/moment-2.15.1.js") Resource moment, @Path(value="${tapestry.asset.root}/bootstrap/js/transition.js") Resource transition, @Path(value="${tapestry.asset.root}/bootstrap4/js/bootstrap-util.js") Resource bootstrapUtil, Compatibility compatibility) {
        String[] modules;
        configuration.add((Object)"underscore", (Object)new JavaScriptModuleConfiguration(underscoreShim));
        configuration.add((Object)"jquery", (Object)new JavaScriptModuleConfiguration(jqueryShim));
        if (compatibility.enabled(Trait.BOOTSTRAP_3)) {
            modules = new String[]{"affix", "alert", "button", "carousel", "collapse", "dropdown", "modal", "scrollspy", "tab", "tooltip"};
            JavaScriptModule.addBootstrap3Modules(configuration, transition, modules);
            Resource popover = transition.forFile("popover.js");
            configuration.add((Object)"bootstrap/popover", (Object)new AMDWrapper(popover).require("bootstrap/tooltip").asJavaScriptModuleConfiguration());
        }
        if (compatibility.enabled(Trait.BOOTSTRAP_4)) {
            configuration.add((Object)"bootstrap/bootstrap-util", (Object)new JavaScriptModuleConfiguration(bootstrapUtil));
            configuration.add((Object)"bootstrap/popper", (Object)new JavaScriptModuleConfiguration(bootstrapUtil.forFile("popper.js")));
            for (String name : new String[]{"alert", "button", "carousel", "collapse", "dropdown", "modal", "scrollspy", "tab", "tooltip"}) {
                Resource lib = bootstrapUtil.forFile(name + ".js");
                if (!lib.exists()) continue;
                configuration.add((Object)("bootstrap/" + name), (Object)new JavaScriptModuleConfiguration(lib).dependsOn("bootstrap/bootstrap-util").dependsOn("bootstrap/popper"));
            }
        }
        if (!compatibility.enabled(Trait.BOOTSTRAP_3) && !compatibility.enabled(Trait.BOOTSTRAP_4)) {
            modules = new String[]{"alert", "dropdown", "collapse"};
            JavaScriptModule.addBootstrap3Modules(configuration, transition, modules);
        }
        configuration.add((Object)"t5/core/typeahead", (Object)new JavaScriptModuleConfiguration(typeahead).dependsOn("jquery"));
        configuration.add((Object)"moment", (Object)new JavaScriptModuleConfiguration(moment));
    }

    private static void addBootstrap3Modules(MappedConfiguration<String, Object> configuration, Resource transition, String[] modules) {
        configuration.add((Object)"bootstrap/transition", (Object)new AMDWrapper(transition).require("jquery", "$").asJavaScriptModuleConfiguration());
        for (String name : modules) {
            Resource lib = transition.forFile(name + ".js");
            configuration.add((Object)("bootstrap/" + name), (Object)new AMDWrapper(lib).require("bootstrap/transition").asJavaScriptModuleConfiguration());
        }
    }

    @Contribute(value=SymbolProvider.class)
    @FactoryDefaults
    public static void setupFactoryDefaults(MappedConfiguration<String, Object> configuration) {
        configuration.add((Object)"tapestry.javascript-infrastructure-provider", (Object)"prototype");
        configuration.add((Object)"tapestry.module-path-prefix", (Object)"modules");
    }

    @Contribute(value=ModuleManager.class)
    public static void setupFoundationFramework(MappedConfiguration<String, Object> configuration, @Symbol(value="tapestry.javascript-infrastructure-provider") String provider, @Path(value="classpath:org/apache/tapestry5/t5-core-dom-prototype.js") Resource domPrototype, @Path(value="classpath:org/apache/tapestry5/t5-core-dom-jquery.js") Resource domJQuery) {
        if (provider.equals("prototype")) {
            configuration.add((Object)"t5/core/dom", (Object)new JavaScriptModuleConfiguration(domPrototype));
        }
        if (provider.equals("jquery")) {
            configuration.add((Object)"t5/core/dom", (Object)new JavaScriptModuleConfiguration(domJQuery));
        }
    }

    @Contribute(value=ModuleManager.class)
    public static void setupApplicationCatalogModules(MappedConfiguration<String, Object> configuration, LocalizationSetter localizationSetter, ComponentMessagesSource messagesSource, ResourceChangeTracker resourceChangeTracker, @Symbol(value="tapestry.compact-json") boolean compactJSON) {
        for (Locale locale : localizationSetter.getSupportedLocales()) {
            MessageCatalogResource resource = new MessageCatalogResource(locale, messagesSource, resourceChangeTracker, compactJSON);
            configuration.add((Object)("t5/core/messages/" + locale.toString()), (Object)new JavaScriptModuleConfiguration(resource));
        }
    }

    @Contribute(value=MarkupRenderer.class)
    public static void prepareHTMLPageOnRender(OrderedConfiguration<MarkupRendererFilter> configuration) {
        configuration.addInstance("ConfigureHTMLElement", ConfigureHTMLElementFilter.class, new String[0]);
        configuration.add("AddBrowserCompatibilityStyles", (Object)new AddBrowserCompatibilityStyles(), new String[0]);
    }

    @Contribute(value=ComponentOverride.class)
    public static void overrideGlyphiconWithFontAwesomeIfNeeded(MappedConfiguration<Class, Class> configuration, Compatibility compatibility) {
        if (!compatibility.enabled(Trait.BOOTSTRAP_3)) {
            configuration.add(Glyphicon.class, FontAwesomeIcon.class);
        }
    }
}

