/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.MixinClasses;
import org.apache.tapestry5.annotations.Mixins;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.internal.services.StringLocation;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.CommonsUtils;
import org.apache.tapestry5.internal.KeyValue;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.transform.ReadOnlyComponentFieldConduit;
import org.apache.tapestry5.ioc.Orderable;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.model.MutableEmbeddedComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class ComponentWorker
implements ComponentClassTransformWorker2 {
    private final ComponentClassResolver resolver;

    public ComponentWorker(ComponentClassResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(Component.class)) {
            this.transformField(plasticClass, model, field);
        }
    }

    private void transformField(PlasticClass transformation, MutableComponentModel model, PlasticField field) {
        Component annotation = (Component)field.getAnnotation(Component.class);
        field.claim((Object)annotation);
        String annotationId = annotation.id();
        String fieldName = field.getName();
        String id = InternalUtils.isNonBlank((String)annotationId) ? annotationId : InternalUtils.stripMemberName((String)fieldName);
        String type = field.getTypeName();
        StringLocation location = new StringLocation(String.format("%s.%s", transformation.getClassName(), fieldName), 0);
        MutableEmbeddedComponentModel embedded = model.addEmbeddedComponent(id, annotation.type(), type, annotation.inheritInformalParameters(), (Location)location);
        this.addParameters(embedded, annotation.parameters());
        this.updateModelWithPublishedParameters(embedded, annotation);
        this.convertAccessToField(field, id);
        this.addMixinClasses(field, embedded);
        this.addMixinTypes(field, embedded);
    }

    private void convertAccessToField(PlasticField field, String id) {
        String fieldName = field.getName();
        ComputedValue<FieldConduit<Object>> computedConduit = this.createProviderForEmbeddedComponentConduit(fieldName, id);
        field.setComputedConduit(computedConduit);
    }

    private ComputedValue<FieldConduit<Object>> createProviderForEmbeddedComponentConduit(final String fieldName, final String id) {
        return new ComputedValue<FieldConduit<Object>>(){

            public FieldConduit<Object> get(InstanceContext context) {
                final ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                return new ReadOnlyComponentFieldConduit(resources, fieldName){

                    public Object get(Object instance, InstanceContext context) {
                        return resources.getEmbeddedComponent(id);
                    }
                };
            }
        };
    }

    private void updateModelWithPublishedParameters(MutableEmbeddedComponentModel embedded, Component annotation) {
        String names = annotation.publishParameters();
        if (InternalUtils.isNonBlank((String)names)) {
            List published = CollectionFactory.newList((Object[])TapestryInternalUtils.splitAtCommas(names));
            embedded.setPublishedParameters(published);
        }
    }

    private void addMixinClasses(PlasticField field, MutableEmbeddedComponentModel model) {
        boolean orderEmpty;
        MixinClasses annotation = (MixinClasses)field.getAnnotation(MixinClasses.class);
        if (annotation == null) {
            return;
        }
        boolean bl = orderEmpty = annotation.order().length == 0;
        if (!orderEmpty && annotation.order().length != annotation.value().length) {
            throw new TapestryException(String.format("%d mixins defined via @MixinClasses on field '%s', but %d ordering constraints \\\n specified (expected 0 or %1$d).", annotation.value().length, field.getName(), annotation.order().length), (Object)model, null);
        }
        for (int i = 0; i < annotation.value().length; ++i) {
            String[] constraints = orderEmpty ? CommonsUtils.EMPTY_STRING_ARRAY : TapestryInternalUtils.splitMixinConstraints(annotation.order()[i]);
            model.addMixin(annotation.value()[i].getName(), constraints);
        }
    }

    private void addMixinTypes(PlasticField field, MutableEmbeddedComponentModel model) {
        Mixins annotation = (Mixins)field.getAnnotation(Mixins.class);
        if (annotation == null) {
            return;
        }
        for (String typeName : annotation.value()) {
            Orderable<String> typeAndOrder = TapestryInternalUtils.mixinTypeAndOrder(typeName);
            String mixinClassName = this.resolver.resolveMixinTypeToClassName((String)typeAndOrder.getTarget());
            model.addMixin(mixinClassName, typeAndOrder.getConstraints());
        }
    }

    private void addParameters(MutableEmbeddedComponentModel embedded, String[] parameters) {
        for (String parameter : parameters) {
            KeyValue kv = TapestryInternalUtils.parseKeyValue(parameter);
            embedded.addParameter(kv.getKey(), kv.getValue());
        }
    }
}

