/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.webdriven.WebDriverBackedSelenium;
import com.thoughtworks.selenium.webdriven.WebDriverCommandProcessor;
import io.github.bonigarcia.wdm.FirefoxDriverManager;
import java.io.File;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.tapestry5.test.ErrorReporter;
import org.apache.tapestry5.test.ErrorReporterImpl;
import org.apache.tapestry5.test.ErrorReportingCommandProcessor;
import org.apache.tapestry5.test.JettyRunner;
import org.apache.tapestry5.test.ServletContainerRunner;
import org.apache.tapestry5.test.TapestryTestConfiguration;
import org.apache.tapestry5.test.TomcatRunner;
import org.apache.tapestry5.test.constants.TapestryRunnerConstants;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.xml.XmlTest;

public abstract class SeleniumTestCase
extends Assert
implements Selenium {
    public static final Logger LOGGER = LoggerFactory.getLogger(SeleniumTestCase.class);
    public static final String PAGE_LOAD_TIMEOUT = "15000";
    public static final String TOMCAT_6 = "tomcat6";
    public static final String JETTY_7 = "jetty7";
    public static final String SUBMIT = "//input[@type='submit']";
    @Deprecated
    protected Selenium selenium;
    protected WebDriver webDriver;
    private String baseURL;
    private ErrorReporter errorReporter;
    private ITestContext testContext;

    @BeforeTest(dependsOnGroups={"beforeStartup"})
    public void testStartup(ITestContext testContext, XmlTest xmlTest) throws Exception {
        if (testContext.getAttribute("tapestry.shutdown") != null) {
            return;
        }
        TapestryTestConfiguration annotation = ((Object)((Object)this)).getClass().getAnnotation(TapestryTestConfiguration.class);
        if (annotation == null) {
            @TapestryTestConfiguration
            final class EmptyInnerClass {
                EmptyInnerClass() {
                }
            }
            annotation = EmptyInnerClass.class.getAnnotation(TapestryTestConfiguration.class);
        }
        String webAppFolder = this.getParameter(xmlTest, "tapestry.web-app-folder", annotation.webAppFolder());
        String container = this.getParameter(xmlTest, "tapestry.servlet-container", annotation.container());
        String contextPath = this.getParameter(xmlTest, "tapestry.context-path", annotation.contextPath());
        int port = this.getIntParameter(xmlTest, "tapestry.port", annotation.port());
        int sslPort = this.getIntParameter(xmlTest, "tapestry.ssl-port", annotation.sslPort());
        String browserStartCommand = this.getParameter(xmlTest, "tapestry.browser-start-command", annotation.browserStartCommand());
        String baseURL = String.format("http://localhost:%d%s/", port, contextPath);
        String sep = System.getProperty("line.separator");
        LOGGER.info("Starting SeleniumTestCase:" + sep + "    currentDir: " + System.getProperty("user.dir") + sep + "  webAppFolder: " + webAppFolder + sep + "     container: " + container + sep + "   contextPath: " + contextPath + sep + String.format("         ports: %d / %d", port, sslPort) + sep + "  browserStart: " + browserStartCommand + sep + "       baseURL: " + baseURL);
        Runnable stopWebServer = this.launchWebServer(container, webAppFolder, contextPath, port, sslPort);
        FirefoxDriverManager.getInstance().setup();
        File ffProfileTemplate = new File(TapestryRunnerConstants.MODULE_BASE_DIR, "src/test/conf/ff_profile_template");
        DesiredCapabilities desiredCapabilities = DesiredCapabilities.firefox();
        desiredCapabilities.setCapability("marionette", true);
        FirefoxOptions options = new FirefoxOptions((Capabilities)desiredCapabilities);
        if (ffProfileTemplate.isDirectory()) {
            FirefoxProfile profile = new FirefoxProfile(ffProfileTemplate);
            options.setProfile(profile);
        }
        FirefoxDriver driver = new FirefoxDriver(options);
        driver.manage().timeouts().implicitlyWait(10L, TimeUnit.SECONDS);
        WebDriverCommandProcessor webDriverCommandProcessor = new WebDriverCommandProcessor(baseURL, (WebDriver)driver);
        ErrorReporterImpl errorReporter = new ErrorReporterImpl((WebDriver)driver, testContext);
        ErrorReportingCommandProcessor commandProcessor = new ErrorReportingCommandProcessor((CommandProcessor)webDriverCommandProcessor, errorReporter);
        WebDriverBackedSelenium selenium = new WebDriverBackedSelenium((WebDriver)driver, baseURL);
        testContext.setAttribute("tapestry.base-url", (Object)baseURL);
        testContext.setAttribute("tapestry.selenium", (Object)selenium);
        testContext.setAttribute("tapestry.error-reporter", (Object)errorReporter);
        testContext.setAttribute("tapestry.command-processor", (Object)commandProcessor);
        testContext.setAttribute("tapestry.shutdown", (Object)new Runnable((Selenium)selenium, stopWebServer, errorReporter, testContext){
            final /* synthetic */ Selenium val$selenium;
            final /* synthetic */ Runnable val$stopWebServer;
            final /* synthetic */ ErrorReporterImpl val$errorReporter;
            final /* synthetic */ ITestContext val$testContext;
            {
                this.val$selenium = selenium;
                this.val$stopWebServer = runnable;
                this.val$errorReporter = errorReporterImpl;
                this.val$testContext = iTestContext;
            }

            @Override
            public void run() {
                try {
                    LOGGER.info("Shutting down selenium client ...");
                    try {
                        this.val$selenium.stop();
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Selenium client shutdown failure.", (Throwable)e);
                    }
                    LOGGER.info("Shutting down webdriver ...");
                    try {
                        if (SeleniumTestCase.this.webDriver != null) {
                            SeleniumTestCase.this.webDriver.quit();
                        }
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Webdriver shutdown failure.", (Throwable)e);
                    }
                    LOGGER.info("Shutting down selenium server ...");
                    LOGGER.info("Shutting web server ...");
                    try {
                        this.val$stopWebServer.run();
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Web server shutdown failure.", (Throwable)e);
                    }
                    this.val$errorReporter.writeOutputPaths();
                }
                finally {
                    this.val$testContext.removeAttribute("tapestry.base-url");
                    this.val$testContext.removeAttribute("tapestry.selenium");
                    this.val$testContext.removeAttribute("tapestry.error-reporter");
                    this.val$testContext.removeAttribute("tapestry.command-processor");
                    this.val$testContext.removeAttribute("tapestry.shutdown");
                }
            }
        });
    }

    private final String getParameter(XmlTest xmlTest, String key, String defaultValue) {
        String value = xmlTest.getParameter(key);
        return value != null ? value : defaultValue;
    }

    private final int getIntParameter(XmlTest xmlTest, String key, int defaultValue) {
        String value = xmlTest.getParameter(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    @AfterTest
    public void testShutdown(ITestContext context) {
        Runnable r = (Runnable)context.getAttribute("tapestry.shutdown");
        if (r != null) {
            LOGGER.info("Shutting down integration test support ...");
            r.run();
        }
    }

    protected Runnable launchWebServer(String container, String webAppFolder, String contextPath, int port, int sslPort) throws Exception {
        final ServletContainerRunner runner = this.createWebServer(container, webAppFolder, contextPath, port, sslPort);
        return new Runnable(){

            @Override
            public void run() {
                runner.stop();
            }
        };
    }

    private ServletContainerRunner createWebServer(String container, String webAppFolder, String contextPath, int port, int sslPort) throws Exception {
        if (TOMCAT_6.equals(container)) {
            return new TomcatRunner(webAppFolder, contextPath, port, sslPort);
        }
        if (JETTY_7.equals(container)) {
            return new JettyRunner(webAppFolder, contextPath, port, sslPort);
        }
        throw new RuntimeException("Unknown servlet container: " + container);
    }

    @BeforeClass
    public void setup(ITestContext context) {
        this.testContext = context;
        this.selenium = (Selenium)context.getAttribute("tapestry.selenium");
        this.webDriver = ((WebDriverBackedSelenium)this.selenium).getWrappedDriver();
        this.baseURL = (String)context.getAttribute("tapestry.base-url");
        this.errorReporter = (ErrorReporter)context.getAttribute("tapestry.error-reporter");
    }

    @AfterClass
    public void cleanup() {
        this.selenium = null;
        this.baseURL = null;
        this.errorReporter = null;
        this.testContext = null;
    }

    protected void writeErrorReport(String reportText) {
        this.errorReporter.writeErrorReport(reportText);
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @BeforeMethod
    public void indicateTestMethodName(Method testMethod) {
        LOGGER.info("Executing " + testMethod);
        this.testContext.setAttribute("tapestry.current-test-method", (Object)testMethod);
        String className = testMethod.getDeclaringClass().getSimpleName();
        String testName = testMethod.getName().replace("_", " ");
        this.selenium.setContext(className + ": " + testName);
    }

    @AfterMethod
    public void cleanupTestMethod() {
        this.testContext.setAttribute("tapestry.current-test-method", null);
    }

    public void addCustomRequestHeader(String key, String value) {
        this.selenium.addCustomRequestHeader(key, value);
    }

    public void addLocationStrategy(String strategyName, String functionDefinition) {
        this.selenium.addLocationStrategy(strategyName, functionDefinition);
    }

    public void addScript(String scriptContent, String scriptTagId) {
        this.selenium.addScript(scriptContent, scriptTagId);
    }

    public void addSelection(String locator, String optionLocator) {
        this.selenium.addSelection(locator, optionLocator);
    }

    public void allowNativeXpath(String allow) {
        this.selenium.allowNativeXpath(allow);
    }

    public void altKeyDown() {
        this.selenium.altKeyDown();
    }

    public void altKeyUp() {
        this.selenium.altKeyUp();
    }

    public void answerOnNextPrompt(String answer) {
        this.selenium.answerOnNextPrompt(answer);
    }

    public void assignId(String locator, String identifier) {
        this.selenium.assignId(locator, identifier);
    }

    public void attachFile(String fieldLocator, String fileLocator) {
        this.selenium.attachFile(fieldLocator, fileLocator);
    }

    public void captureEntirePageScreenshot(String filename, String kwargs) {
        this.selenium.captureEntirePageScreenshot(filename, kwargs);
    }

    public String captureEntirePageScreenshotToString(String kwargs) {
        return this.selenium.captureEntirePageScreenshotToString(kwargs);
    }

    public String captureNetworkTraffic(String type) {
        return this.selenium.captureNetworkTraffic(type);
    }

    public void captureScreenshot(String filename) {
        this.selenium.captureScreenshot(filename);
    }

    public String captureScreenshotToString() {
        return this.selenium.captureScreenshotToString();
    }

    public void check(String locator) {
        WebElement element = this.webDriver.findElement(SeleniumTestCase.convertLocator(locator));
        if (!element.isSelected()) {
            this.scrollIntoView(element);
            element.click();
        }
    }

    public void chooseCancelOnNextConfirmation() {
        this.selenium.chooseCancelOnNextConfirmation();
    }

    public void chooseOkOnNextConfirmation() {
        this.selenium.chooseOkOnNextConfirmation();
    }

    public void click(String locator) {
        WebElement element = this.webDriver.findElement(SeleniumTestCase.convertLocator(locator));
        this.scrollIntoView(element);
        JavascriptExecutor executor = (JavascriptExecutor)this.webDriver;
        executor.executeScript("arguments[0].click();", new Object[]{element});
    }

    public void clickAt(String locator, String coordString) {
        this.selenium.clickAt(locator, coordString);
    }

    public void close() {
        this.selenium.close();
    }

    public void contextMenu(String locator) {
        this.selenium.contextMenu(locator);
    }

    public void contextMenuAt(String locator, String coordString) {
        this.selenium.contextMenuAt(locator, coordString);
    }

    public void controlKeyDown() {
        this.selenium.controlKeyDown();
    }

    public void controlKeyUp() {
        this.selenium.controlKeyUp();
    }

    public void createCookie(String nameValuePair, String optionsString) {
        this.selenium.createCookie(nameValuePair, optionsString);
    }

    public void deleteAllVisibleCookies() {
        this.selenium.deleteAllVisibleCookies();
    }

    public void deleteCookie(String name, String optionsString) {
        this.selenium.deleteCookie(name, optionsString);
    }

    public void deselectPopUp() {
        this.selenium.deselectPopUp();
    }

    public void doubleClick(String locator) {
        this.selenium.doubleClick(locator);
    }

    public void doubleClickAt(String locator, String coordString) {
        this.selenium.doubleClickAt(locator, coordString);
    }

    public void dragAndDrop(String locator, String movementsString) {
        this.selenium.dragAndDrop(locator, movementsString);
    }

    public void dragAndDropToObject(String locatorOfObjectToBeDragged, String locatorOfDragDestinationObject) {
        this.selenium.dragAndDropToObject(locatorOfObjectToBeDragged, locatorOfDragDestinationObject);
    }

    public void dragdrop(String locator, String movementsString) {
        this.selenium.dragdrop(locator, movementsString);
    }

    public void fireEvent(String locator, String eventName) {
        this.selenium.fireEvent(locator, eventName);
    }

    public void focus(String locator) {
        this.selenium.focus(locator);
    }

    public String getAlert() {
        return this.selenium.getAlert();
    }

    public String[] getAllButtons() {
        return this.selenium.getAllButtons();
    }

    public String[] getAllFields() {
        return this.selenium.getAllFields();
    }

    public String[] getAllLinks() {
        return this.selenium.getAllLinks();
    }

    public String[] getAllWindowIds() {
        return this.selenium.getAllWindowIds();
    }

    public String[] getAllWindowNames() {
        return this.selenium.getAllWindowNames();
    }

    public String[] getAllWindowTitles() {
        return this.selenium.getAllWindowTitles();
    }

    public String getAttribute(String attributeLocator) {
        return this.selenium.getAttribute(attributeLocator);
    }

    public String[] getAttributeFromAllWindows(String attributeName) {
        return this.selenium.getAttributeFromAllWindows(attributeName);
    }

    public String getBodyText() {
        return this.selenium.getBodyText();
    }

    public String getConfirmation() {
        return this.selenium.getConfirmation();
    }

    public String getCookie() {
        return this.selenium.getCookie();
    }

    public String getCookieByName(String name) {
        return this.selenium.getCookieByName(name);
    }

    public Number getCursorPosition(String locator) {
        return this.selenium.getCursorPosition(locator);
    }

    public Number getElementHeight(String locator) {
        return this.selenium.getElementHeight(locator);
    }

    public Number getElementIndex(String locator) {
        return this.selenium.getElementIndex(locator);
    }

    public Number getElementPositionLeft(String locator) {
        return this.selenium.getElementPositionLeft(locator);
    }

    public Number getElementPositionTop(String locator) {
        return this.selenium.getElementPositionTop(locator);
    }

    public Number getElementWidth(String locator) {
        return this.selenium.getElementWidth(locator);
    }

    public String getEval(String script) {
        return this.selenium.getEval(script);
    }

    public String getExpression(String expression) {
        return this.selenium.getExpression(expression);
    }

    public String getHtmlSource() {
        return this.selenium.getHtmlSource();
    }

    public String getLocation() {
        return this.selenium.getLocation();
    }

    public String getLog() {
        return this.selenium.getLog();
    }

    public Number getMouseSpeed() {
        return this.selenium.getMouseSpeed();
    }

    public String getPrompt() {
        return this.selenium.getPrompt();
    }

    public String getSelectedId(String selectLocator) {
        return this.selenium.getSelectedId(selectLocator);
    }

    public String[] getSelectedIds(String selectLocator) {
        return this.selenium.getSelectedIds(selectLocator);
    }

    public String getSelectedIndex(String selectLocator) {
        return this.selenium.getSelectedIndex(selectLocator);
    }

    public String[] getSelectedIndexes(String selectLocator) {
        return this.selenium.getSelectedIndexes(selectLocator);
    }

    public String getSelectedLabel(String selectLocator) {
        return this.selenium.getSelectedLabel(selectLocator);
    }

    public String[] getSelectedLabels(String selectLocator) {
        return this.selenium.getSelectedLabels(selectLocator);
    }

    public String getSelectedValue(String selectLocator) {
        return this.selenium.getSelectedValue(selectLocator);
    }

    public String[] getSelectedValues(String selectLocator) {
        return this.selenium.getSelectedValues(selectLocator);
    }

    public String[] getSelectOptions(String selectLocator) {
        return this.selenium.getSelectOptions(selectLocator);
    }

    public String getSpeed() {
        return this.selenium.getSpeed();
    }

    public String getTable(String tableCellAddress) {
        return this.selenium.getTable(tableCellAddress);
    }

    public String getText(String locator) {
        return this.selenium.getText(locator);
    }

    public String getTitle() {
        return this.selenium.getTitle();
    }

    public String getValue(String locator) {
        return this.selenium.getValue(locator);
    }

    public boolean getWhetherThisFrameMatchFrameExpression(String currentFrameString, String target) {
        return this.selenium.getWhetherThisFrameMatchFrameExpression(currentFrameString, target);
    }

    public boolean getWhetherThisWindowMatchWindowExpression(String currentWindowString, String target) {
        return this.selenium.getWhetherThisWindowMatchWindowExpression(currentWindowString, target);
    }

    public Number getXpathCount(String xpath) {
        return this.selenium.getXpathCount(xpath);
    }

    public void goBack() {
        this.selenium.goBack();
    }

    public void highlight(String locator) {
        this.selenium.highlight(locator);
    }

    public void ignoreAttributesWithoutValue(String ignore) {
        this.selenium.ignoreAttributesWithoutValue(ignore);
    }

    public boolean isAlertPresent() {
        return this.selenium.isAlertPresent();
    }

    public boolean isChecked(String locator) {
        return this.selenium.isChecked(locator);
    }

    public boolean isConfirmationPresent() {
        return this.selenium.isConfirmationPresent();
    }

    public boolean isCookiePresent(String name) {
        return this.selenium.isCookiePresent(name);
    }

    public boolean isEditable(String locator) {
        return this.selenium.isEditable(locator);
    }

    public boolean isElementPresent(String locator) {
        return !this.webDriver.findElements(SeleniumTestCase.convertLocator(locator)).isEmpty();
    }

    public boolean isOrdered(String locator1, String locator2) {
        return this.selenium.isOrdered(locator1, locator2);
    }

    public boolean isPromptPresent() {
        return this.selenium.isPromptPresent();
    }

    public boolean isSomethingSelected(String selectLocator) {
        return this.selenium.isSomethingSelected(selectLocator);
    }

    public boolean isTextPresent(String pattern) {
        return this.selenium.isTextPresent(pattern);
    }

    public boolean isVisible(String locator) {
        return this.selenium.isVisible(locator);
    }

    public void keyDown(String locator, String keySequence) {
        this.selenium.keyDown(locator, keySequence);
    }

    public void keyDownNative(String keycode) {
        this.selenium.keyDownNative(keycode);
    }

    public void keyPress(String locator, String keySequence) {
        this.selenium.keyPress(locator, keySequence);
    }

    public void keyPressNative(String keycode) {
        this.selenium.keyPressNative(keycode);
    }

    public void keyUp(String locator, String keySequence) {
        this.selenium.keyUp(locator, keySequence);
    }

    public void keyUpNative(String keycode) {
        this.selenium.keyUpNative(keycode);
    }

    public void metaKeyDown() {
        this.selenium.metaKeyDown();
    }

    public void metaKeyUp() {
        this.selenium.metaKeyUp();
    }

    public void mouseDown(String locator) {
        this.selenium.mouseDown(locator);
    }

    public void mouseDownAt(String locator, String coordString) {
        this.selenium.mouseDownAt(locator, coordString);
    }

    public void mouseDownRight(String locator) {
        this.selenium.mouseDownRight(locator);
    }

    public void mouseDownRightAt(String locator, String coordString) {
        this.selenium.mouseDownRightAt(locator, coordString);
    }

    public void mouseMove(String locator) {
        this.selenium.mouseMove(locator);
    }

    public void mouseMoveAt(String locator, String coordString) {
        this.selenium.mouseMoveAt(locator, coordString);
    }

    public void mouseOut(String locator) {
        this.selenium.mouseOut(locator);
    }

    public void mouseOver(String locator) {
        this.selenium.mouseOver(locator);
    }

    public void mouseUp(String locator) {
        this.selenium.mouseUp(locator);
    }

    public void mouseUpAt(String locator, String coordString) {
        this.selenium.mouseUpAt(locator, coordString);
    }

    public void mouseUpRight(String locator) {
        this.selenium.mouseUpRight(locator);
    }

    public void mouseUpRightAt(String locator, String coordString) {
        this.selenium.mouseUpRightAt(locator, coordString);
    }

    public void open(String url) {
        this.selenium.open(url);
    }

    public void open(String url, String ignoreResponseCode) {
        this.selenium.open(url, ignoreResponseCode);
    }

    public void openWindow(String url, String windowID) {
        this.selenium.openWindow(url, windowID);
    }

    public void refresh() {
        this.selenium.refresh();
    }

    public void removeAllSelections(String locator) {
        this.selenium.removeAllSelections(locator);
    }

    public void removeScript(String scriptTagId) {
        this.selenium.removeScript(scriptTagId);
    }

    public void removeSelection(String locator, String optionLocator) {
        this.selenium.removeSelection(locator, optionLocator);
    }

    public String retrieveLastRemoteControlLogs() {
        return this.selenium.retrieveLastRemoteControlLogs();
    }

    public void rollup(String rollupName, String kwargs) {
        this.selenium.rollup(rollupName, kwargs);
    }

    public void runScript(String script) {
        this.selenium.runScript(script);
    }

    public void select(String selectLocator, String optionLocator) {
        this.selenium.select(selectLocator, optionLocator);
    }

    public void selectFrame(String locator) {
        this.selenium.selectFrame(locator);
    }

    public void selectPopUp(String windowID) {
        this.selenium.selectPopUp(windowID);
    }

    public void selectWindow(String windowID) {
        this.selenium.selectWindow(windowID);
    }

    public void setBrowserLogLevel(String logLevel) {
        this.selenium.setBrowserLogLevel(logLevel);
    }

    public void setContext(String context) {
        this.selenium.setContext(context);
    }

    public void setCursorPosition(String locator, String position) {
        this.selenium.setCursorPosition(locator, position);
    }

    public void setExtensionJs(String extensionJs) {
        this.selenium.setExtensionJs(extensionJs);
    }

    public void setMouseSpeed(String pixels) {
        this.selenium.setMouseSpeed(pixels);
    }

    public void setSpeed(String value) {
        this.selenium.setSpeed(value);
    }

    public void setTimeout(String timeout) {
        this.selenium.setTimeout(timeout);
    }

    public void shiftKeyDown() {
        this.selenium.shiftKeyDown();
    }

    public void shiftKeyUp() {
        this.selenium.shiftKeyUp();
    }

    public void showContextualBanner() {
        this.selenium.showContextualBanner();
    }

    public void showContextualBanner(String className, String methodName) {
        this.selenium.showContextualBanner(className, methodName);
    }

    public void shutDownSeleniumServer() {
        this.selenium.shutDownSeleniumServer();
    }

    public void start() {
        this.selenium.start();
    }

    public void start(Object optionsObject) {
        this.selenium.start(optionsObject);
    }

    public void start(String optionsString) {
        this.selenium.start(optionsString);
    }

    public void stop() {
        this.selenium.stop();
    }

    public void submit(String formLocator) {
        this.selenium.submit(formLocator);
    }

    public void type(String locator, String value) {
        WebElement element = this.webDriver.findElement(SeleniumTestCase.convertLocator(locator));
        ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].value = arguments[1];", new Object[]{element, value});
    }

    public void typeKeys(String locator, String value) {
        WebElement element = this.webDriver.findElement(SeleniumTestCase.convertLocator(locator));
        element.sendKeys(new CharSequence[]{value});
    }

    public void uncheck(String locator) {
        this.selenium.uncheck(locator);
    }

    public void useXpathLibrary(String libraryName) {
        this.selenium.useXpathLibrary(libraryName);
    }

    public void waitForCondition(String script, String timeout) {
        this.selenium.waitForCondition(script, timeout);
    }

    protected void waitForCondition(ExpectedCondition condition) {
        this.waitForCondition(condition, 10L);
    }

    protected void waitForCondition(ExpectedCondition condition, long timeoutSeconds) {
        WebDriverWait wait = new WebDriverWait(this.webDriver, timeoutSeconds);
        wait.until((Function)condition);
    }

    public void waitForFrameToLoad(String frameAddress, String timeout) {
        this.selenium.waitForFrameToLoad(frameAddress, timeout);
    }

    public void waitForPageToLoad(String timeout) {
        this.selenium.waitForPageToLoad(timeout);
        try {
            WebElement body = this.webDriver.findElement(By.cssSelector((String)"body"));
            if (body.getAttribute("data-page-initialized") == null) {
                return;
            }
            this.waitForCssSelectorToAppear("body[data-page-initialized='true']");
        }
        catch (NoSuchElementException body) {
        }
        catch (StaleElementReferenceException e) {
            e.printStackTrace();
            System.out.println("Continuing execution after exception above.");
        }
    }

    public void waitForPopUp(String windowID, String timeout) {
        this.selenium.waitForPopUp(windowID, timeout);
    }

    public void windowFocus() {
        this.selenium.windowFocus();
    }

    public void windowMaximize() {
        this.selenium.windowMaximize();
    }

    public void scrollIntoView(WebElement element) {
        ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].scrollIntoView(true);", new Object[]{element});
    }

    protected final void reportAndThrowAssertionError(String message, Object ... arguments) {
        StringBuilder builder = new StringBuilder(5000);
        String formatted = String.format(message, arguments);
        builder.append(formatted);
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder buffer = new StringBuilder(5000);
        boolean enabled = false;
        for (StackTraceElement e : stackTrace) {
            if (enabled) {
                buffer.append("\n- ");
                buffer.append(e);
                continue;
            }
            if (!e.getMethodName().equals("reportAndThrowAssertionError")) continue;
            enabled = true;
        }
        this.writeErrorReport(builder.toString());
        throw new AssertionError((Object)formatted);
    }

    protected final void unreachable() {
        this.reportAndThrowAssertionError("An unreachable statement was reached.", new Object[0]);
    }

    protected final void openBaseURL() {
        this.open(this.baseURL);
        this.waitForPageToLoad();
    }

    protected final void assertText(String locator, String expected) {
        String actual = null;
        try {
            actual = this.getText(locator);
        }
        catch (RuntimeException ex) {
            System.err.printf("Error accessing %s: %s, in:\n\n%s\n\n", locator, ex.getMessage(), this.getHtmlSource());
            throw ex;
        }
        if (actual.equals(expected)) {
            return;
        }
        this.reportAndThrowAssertionError("%s was '%s' not '%s'", locator, actual, expected);
    }

    protected final void assertTextPresent(String ... text) {
        for (String item : text) {
            if (this.isTextPresent(item)) continue;
            this.reportAndThrowAssertionError("Page did not contain '" + item + "'.", new Object[0]);
        }
    }

    protected final void assertSourcePresent(String ... expected) {
        String source = this.getHtmlSource();
        for (String snippet : expected) {
            if (source.contains(snippet)) continue;
            this.reportAndThrowAssertionError("Page did not contain source '" + snippet + "'.", new Object[0]);
        }
    }

    protected final void clickAndWait(String locator) {
        this.click(locator);
        this.waitForPageToLoad();
    }

    protected final void waitForPageToLoad() {
        this.waitForPageToLoad(PAGE_LOAD_TIMEOUT);
    }

    protected final void assertAttribute(String locator, String expected) {
        String actual = null;
        try {
            actual = this.getAttribute(locator);
        }
        catch (RuntimeException ex) {
            this.reportAndThrowAssertionError("Error accessing %s: %s", locator, ex.getMessage());
        }
        if (actual.equals(expected)) {
            return;
        }
        this.reportAndThrowAssertionError("%s was '%s' not '%s'", locator, actual, expected);
    }

    protected final void assertFieldValue(String locator, String expected) {
        try {
            SeleniumTestCase.assertEquals((String)this.getValue(locator), (String)expected);
        }
        catch (AssertionError ex) {
            this.reportAndThrowAssertionError("Failure accessing %s: %s", locator, ex);
        }
    }

    protected final void openLinks(String ... linkText) {
        this.openBaseURL();
        if (this.getTitle().toLowerCase().contains("service unavailable")) {
            throw new RuntimeException("Webapp didn't start correctly. HTML contents: " + this.getHtmlSource());
        }
        for (String text : linkText) {
            this.clickAndWait("link=" + text);
        }
    }

    protected final void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected final void waitForElementToAppear(String elementId) {
        String condition = String.format("selenium.browserbot.getCurrentWindow().document.getElementById(\"%s\")", elementId);
        this.waitForCondition(condition, PAGE_LOAD_TIMEOUT);
    }

    protected final void waitForCssSelectorToAppear(String selector) {
        String condition = String.format("selenium.browserbot.getCurrentWindow().document.querySelector(\"%s\")", selector);
        this.waitForCondition(condition, PAGE_LOAD_TIMEOUT);
    }

    protected final void waitForElementToDisappear(String elementId) {
        String condition = String.format("selenium.browserbot.getCurrentWindow().testSupport.doesNotExist(\"%s\")", elementId);
        this.waitForCondition(condition, PAGE_LOAD_TIMEOUT);
    }

    protected final void waitForVisible(String selector) {
        this.waitForCondition(ExpectedConditions.visibilityOfElementLocated((By)SeleniumTestCase.convertLocator(selector)));
    }

    protected final void waitForInvisible(String selector) {
        this.waitForCondition(ExpectedConditions.invisibilityOfElementLocated((By)SeleniumTestCase.convertLocator(selector)));
    }

    protected final void assertTitle(String expected) {
        try {
            SeleniumTestCase.assertEquals((String)this.getTitle(), (String)expected);
        }
        catch (AssertionError ex) {
            this.reportAndThrowAssertionError("Unexpected title: %s", ex);
            throw ex;
        }
    }

    protected final void waitForAjaxRequestsToComplete(String timeout) {
        this.waitForAjaxRequestsToComplete();
    }

    protected final void waitForAjaxRequestsToComplete() {
        this.sleep(250L);
        for (int i = 0; i < 10; ++i) {
            if (i > 0) {
                this.sleep(100L);
            }
            if (!this.getCssCount("body[data-ajax-active='0']").equals(1)) continue;
            return;
        }
        this.reportAndThrowAssertionError("Body 'data-ajax-active' attribute never reverted to '0'.", new Object[0]);
    }

    public Number getCssCount(String str) {
        return this.selenium.getCssCount(str);
    }

    protected static By convertLocator(String locator) {
        if (locator.startsWith("link=")) {
            return By.linkText((String)locator.substring(5));
        }
        if (locator.startsWith("css=")) {
            return By.cssSelector((String)locator.substring(4));
        }
        if (locator.startsWith("xpath=")) {
            return By.xpath((String)locator.substring(6));
        }
        if (locator.startsWith("id=")) {
            return By.id((String)locator.substring(3));
        }
        if (locator.startsWith("//")) {
            return By.xpath((String)locator);
        }
        return By.id((String)locator);
    }
}

