/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.io.IOException;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.commons.util.Stack;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.OperationException;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.slf4j.Logger;

public class OperationTrackerImpl
implements OperationTracker {
    private final Logger logger;
    private final Stack<String> operations = CollectionFactory.newStack();
    private boolean logged;

    public OperationTrackerImpl(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String description, Runnable operation) {
        assert (InternalUtils.isNonBlank(description));
        assert (operation != null);
        long startNanos = this.start(description);
        try {
            operation.run();
            this.finish(description, startNanos);
        }
        catch (RuntimeException ex) {
            this.logAndRethrow(ex);
        }
        catch (Error ex) {
            this.handleError(ex);
        }
        finally {
            this.handleFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(String description, Invokable<T> operation) {
        assert (InternalUtils.isNonBlank(description));
        assert (operation != null);
        long startNanos = this.start(description);
        try {
            T result = operation.invoke();
            this.finish(description, startNanos);
            T t = result;
            return t;
        }
        catch (RuntimeException ex) {
            T t = this.logAndRethrow(ex);
            return t;
        }
        catch (Error ex) {
            T t = this.handleError(ex);
            return t;
        }
        finally {
            this.handleFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T perform(String description, IOOperation<T> operation) throws IOException {
        InternalUtils.isNonBlank(description);
        assert (operation != null);
        long startNanos = this.start(description);
        try {
            T result = operation.perform();
            this.finish(description, startNanos);
            T t = result;
            return t;
        }
        catch (RuntimeException ex) {
            T t = this.logAndRethrow(ex);
            return t;
        }
        catch (Error ex) {
            T t = this.handleError(ex);
            return t;
        }
        catch (IOException ex) {
            T t = this.logAndRethrow(ex);
            return t;
        }
        finally {
            this.handleFinally();
        }
    }

    private void handleFinally() {
        this.operations.pop();
        if (this.operations.isEmpty()) {
            this.logged = false;
        }
    }

    private <T> T handleError(Error error) {
        if (!this.logged) {
            this.log(error);
            this.logged = true;
        }
        throw error;
    }

    private void finish(String description, long startNanos) {
        if (this.logger.isDebugEnabled()) {
            long elapsedNanos = System.nanoTime() - startNanos;
            double elapsedMillis = (double)elapsedNanos / 1000000.0;
            this.logger.debug(String.format("[%3d] <-- %s [%,.2f ms]", this.operations.getDepth(), description, elapsedMillis));
        }
    }

    private long start(String description) {
        long startNanos = -1L;
        if (this.logger.isDebugEnabled()) {
            startNanos = System.nanoTime();
            this.logger.debug(String.format("[%3d] --> %s", this.operations.getDepth() + 1, description));
        }
        this.operations.push((Object)description);
        return startNanos;
    }

    private <T> T logAndRethrow(RuntimeException ex) {
        if (!this.logged) {
            String[] trace = this.log(ex);
            this.logged = true;
            throw new OperationException(ex, trace);
        }
        throw ex;
    }

    private <T> T logAndRethrow(IOException ex) throws IOException {
        if (!this.logged) {
            String[] trace = this.log(ex);
            this.logged = true;
            throw new OperationException(ex, trace);
        }
        throw ex;
    }

    private String[] log(Throwable ex) {
        this.logger.error(ExceptionUtils.toMessage((Throwable)ex));
        this.logger.error("Operations trace:");
        Object[] snapshot = this.operations.getSnapshot();
        String[] trace = new String[snapshot.length];
        for (int i = 0; i < snapshot.length; ++i) {
            trace[i] = snapshot[i].toString();
            this.logger.error(String.format("[%2d] %s", i + 1, trace[i]));
        }
        return trace;
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }
}

