/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.validator;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.commons.MessageFormatter;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Html5Support;
import org.apache.tapestry5.services.javascript.DataConstants;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.validator.AbstractValidator;

public class Max
extends AbstractValidator<Long, Number> {
    private final Html5Support html5Support;

    public Max(JavaScriptSupport javaScriptSupport, Html5Support html5Support) {
        super(Long.class, Number.class, "max-integer", javaScriptSupport);
        this.html5Support = html5Support;
    }

    @Override
    public void validate(Field field, Long constraintValue, MessageFormatter formatter, Number value) throws ValidationException {
        if (value.longValue() > constraintValue) {
            throw new ValidationException(this.buildMessage(formatter, field, constraintValue));
        }
    }

    private String buildMessage(MessageFormatter formatter, Field field, Long constraintValue) {
        return formatter.format(new Object[]{constraintValue, field.getLabel()});
    }

    @Override
    public void render(Field field, Long constraintValue, MessageFormatter formatter, MarkupWriter writer, FormSupport formSupport) {
        if (formSupport.isClientValidationEnabled()) {
            this.javaScriptSupport.require("t5/core/validation");
            writer.attributes(DataConstants.VALIDATION_ATTRIBUTE, true, "data-validate-max", constraintValue.toString(), "data-max-message", this.buildMessage(formatter, field, constraintValue));
        }
        if (this.html5Support.isHtml5SupportEnabled()) {
            writer.getElement().forceAttributes("type", "number", "max", String.valueOf(constraintValue));
        }
    }
}

