/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.rest;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry5.annotations.ActivationContextParameter;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.RequestBody;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.annotations.RestInfo;
import org.apache.tapestry5.annotations.StaticActivationContextValue;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.commons.util.CommonsUtils;
import org.apache.tapestry5.http.services.BaseURLSource;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.services.PageSource;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.messages.ComponentMessagesSource;
import org.apache.tapestry5.services.rest.MappedEntityManager;
import org.apache.tapestry5.services.rest.OpenApiDescriptionGenerator;
import org.apache.tapestry5.services.rest.OpenApiTypeDescriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpenApiDescriptionGenerator
implements OpenApiDescriptionGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOpenApiDescriptionGenerator.class);
    private final OpenApiTypeDescriber typeDescriber;
    private final BaseURLSource baseUrlSource;
    private final SymbolSource symbolSource;
    private final ComponentMessagesSource componentMessagesSource;
    private final ThreadLocale threadLocale;
    private final PageSource pageSource;
    private final ThreadLocal<Messages> messages;
    private final ComponentClassResolver componentClassResolver;
    private final PageRenderLinkSource pageRenderLinkSource;
    private final Request request;
    final Set<Class<?>> entities;
    private static final String KEY_PREFIX = "openapi.";
    private final String basePath;
    private final Map<String, Class<?>> stringToClassMap = new HashMap();
    private static final String PREFIX = "http".toLowerCase();

    public DefaultOpenApiDescriptionGenerator(OpenApiTypeDescriber typeDescriber, MappedEntityManager mappedEntityManager, BaseURLSource baseUrlSource, SymbolSource symbolSource, ComponentMessagesSource componentMessagesSource, ThreadLocale threadLocale, PageSource pageSource, ComponentClassResolver componentClassResolver, PageRenderLinkSource pageRenderLinkSource, Request request) {
        this.typeDescriber = typeDescriber;
        this.baseUrlSource = baseUrlSource;
        this.symbolSource = symbolSource;
        this.componentMessagesSource = componentMessagesSource;
        this.threadLocale = threadLocale;
        this.pageSource = pageSource;
        this.componentClassResolver = componentClassResolver;
        this.pageRenderLinkSource = pageRenderLinkSource;
        this.request = request;
        this.entities = mappedEntityManager.getEntities();
        this.messages = new ThreadLocal();
        this.basePath = symbolSource.valueForSymbol("tapestry.openapi-base-path");
        if (!this.basePath.startsWith("/") || !this.basePath.endsWith("/")) {
            throw new RuntimeException(String.format("The value of the %s (%s) configuration symbol is '%s' is invalid. It should start with a slash and not end with one", "tapestry.openapi-base-path", "SymbolConstants.OPENAPI_BASE_PATH", this.basePath));
        }
        this.stringToClassMap.put("boolean", Boolean.TYPE);
        this.stringToClassMap.put("byte", Byte.TYPE);
        this.stringToClassMap.put("short", Short.TYPE);
        this.stringToClassMap.put("int", Integer.TYPE);
        this.stringToClassMap.put("long", Long.TYPE);
        this.stringToClassMap.put("float", Float.TYPE);
        this.stringToClassMap.put("double", Double.TYPE);
        this.stringToClassMap.put("char", Character.TYPE);
        for (Class<?> entity : this.entities) {
            this.stringToClassMap.put(entity.getName(), entity);
        }
    }

    @Override
    public JSONObject generate(JSONObject documentation) {
        for (String pageName : this.componentClassResolver.getPageNames()) {
            try {
                this.pageSource.getPage(pageName);
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Exception while intantiating page %s for OpenAPI description generation,", pageName), (Throwable)e);
                e.printStackTrace();
            }
        }
        this.messages.set(this.componentMessagesSource.getApplicationCatalog(this.threadLocale.getLocale()));
        if (documentation == null) {
            documentation = new JSONObject();
        }
        documentation.put("openapi", (Object)this.symbolSource.valueForSymbol("tapestry.openapi-version"));
        this.generateInfo(documentation);
        JSONArray servers = new JSONArray();
        servers.add((Object)new JSONObject(new Object[]{"url", this.baseUrlSource.getBaseURL(this.request.isSecure()) + this.basePath.substring(0, this.basePath.length() - 1)}));
        documentation.put("servers", (Object)servers);
        try {
            this.addPaths(documentation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.generateSchemas(documentation);
        return documentation;
    }

    private void generateInfo(JSONObject documentation) {
        JSONObject info = new JSONObject();
        this.putIfNotEmpty(info, "title", "tapestry.openapi-title");
        this.putIfNotEmpty(info, "description", "tapestry.openapi-description");
        info.put("version", (Object)this.getValueFromSymbolNoPrefix("tapestry.openapi-application-version").orElse("?"));
        documentation.put("info", (Object)info);
    }

    private void addPaths(JSONObject documentation) throws NoSuchMethodException, SecurityException {
        List pagesWithRestEndpoints = this.pageSource.getAllPages().stream().filter(DefaultOpenApiDescriptionGenerator::hasRestEndpoint).collect(Collectors.toList());
        JSONObject paths = new JSONObject();
        JSONArray tags = new JSONArray();
        for (Page page : pagesWithRestEndpoints) {
            this.processPageClass(page, paths, tags);
        }
        documentation.put("tags", (Object)tags);
        documentation.put("paths", (Object)paths);
    }

    private void processPageClass(Page page, JSONObject paths, JSONArray tags) throws NoSuchMethodException {
        Class<?> pageClass = page.getRootComponent().getClass();
        String tagName = this.addPageTag(tags, pageClass);
        ComponentModel model = page.getRootComponent().getComponentResources().getComponentModel();
        JSONArray methodsAsJson = this.getMethodsAsJson(model);
        List<Method> methods = this.toMethods(methodsAsJson, pageClass);
        for (Method method : methods) {
            this.processMethod(method, pageClass, paths, tagName);
        }
    }

    private String addPageTag(JSONArray tags, Class<?> pageClass) {
        String tagName = this.getValue(pageClass, "tag.name").orElse(pageClass.getSimpleName());
        JSONObject tag = new JSONObject();
        tag.put("name", (Object)tagName);
        this.putIfNotEmpty(tag, "description", this.getValue(pageClass, "tag.description"));
        tags.add((Object)tag);
        return tagName;
    }

    private JSONArray getMethodsAsJson(ComponentModel model) {
        JSONArray methodsAsJson = new JSONArray();
        while (model != null) {
            String meta = model.getMeta("restEndpointEventHandlerMethods");
            if (meta != null) {
                JSONArray thisMethodArray = new JSONArray(meta);
                this.addElementsIfNotPresent(methodsAsJson, thisMethodArray);
            }
            model = model.getParentModel();
        }
        return methodsAsJson;
    }

    private void processMethod(Method method, Class<?> pageClass, JSONObject paths, String tagName) {
        JSONObject path;
        String uri = this.getPath(method, pageClass);
        if (paths.containsKey((Object)uri)) {
            path = paths.getJSONObject(uri);
        } else {
            path = new JSONObject();
            paths.put(uri, (Object)path);
        }
        String httpMethod = DefaultOpenApiDescriptionGenerator.getHttpMethod(method);
        if (path.containsKey((Object)httpMethod)) {
            throw new RuntimeException(String.format("There are at least two different REST endpoints for path %s and HTTP method %s in class %s", uri, httpMethod.toUpperCase(), pageClass.getName()));
        }
        JSONObject methodDescription = new JSONObject();
        this.putIfNotEmpty(methodDescription, "summary", this.getValue(method, uri, httpMethod, "summary"));
        this.putIfNotEmpty(methodDescription, "description", this.getValue(method, uri, httpMethod, "description"));
        JSONArray methodTags = new JSONArray();
        methodTags.add((Object)tagName);
        methodDescription.put("tags", (Object)methodTags);
        this.processResponses(method, uri, httpMethod, methodDescription);
        this.processParameters(method, uri, httpMethod, methodDescription);
        path.put(httpMethod, (Object)methodDescription);
    }

    private void processParameters(Method method, String uri, String httpMethod, JSONObject methodDescription) {
        JSONArray parametersAsJsonArray = new JSONArray();
        for (Parameter parameter : method.getParameters()) {
            JSONObject parameterDescription = new JSONObject();
            if (!DefaultOpenApiDescriptionGenerator.isIgnored(parameter) && !parameter.isAnnotationPresent(StaticActivationContextValue.class)) {
                parameterDescription.put("in", (Object)"path");
            } else if (parameter.isAnnotationPresent(RequestParameter.class)) {
                parameterDescription.put("in", (Object)"query");
            } else if (parameter.isAnnotationPresent(RequestBody.class)) {
                this.processRequestBody(method, uri, httpMethod, methodDescription, parametersAsJsonArray, parameter);
            }
            if (parameterDescription.isEmpty()) continue;
            parameterDescription.put("name", (Object)this.getParameterName(parameter));
            this.getValue(method, uri, httpMethod, parameter, "description").ifPresent(v -> parameterDescription.put("description", v));
            this.typeDescriber.describe(parameterDescription, parameter);
            parametersAsJsonArray.add((Object)parameterDescription);
        }
        if (!parametersAsJsonArray.isEmpty()) {
            methodDescription.put("parameters", (Object)parametersAsJsonArray);
        }
    }

    private void processRequestBody(Method method, String uri, String httpMethod, JSONObject methodDescription, JSONArray parametersAsJsonArray, Parameter parameter) {
        JSONObject requestBodyDescription = new JSONObject();
        requestBodyDescription.put("required", (Object)(!parameter.getAnnotation(RequestBody.class).allowEmpty() ? 1 : 0));
        this.getValue(method, uri, httpMethod, "requestbody.description").ifPresent(v -> requestBodyDescription.put("description", v));
        RestInfo restInfo = method.getAnnotation(RestInfo.class);
        if (restInfo != null) {
            JSONObject contentDescription = new JSONObject();
            for (String contentType : restInfo.consumes()) {
                JSONObject schemaDescription = new JSONObject();
                this.typeDescriber.describe(schemaDescription, parameter);
                schemaDescription.remove((Object)"required");
                contentDescription.put(contentType, (Object)schemaDescription);
            }
            requestBodyDescription.put("content", (Object)contentDescription);
        }
        methodDescription.put("requestBody", (Object)requestBodyDescription);
    }

    private String getParameterName(Parameter parameter) {
        ActivationContextParameter activationContextParameter;
        String name = null;
        RequestParameter requestParameter = parameter.getAnnotation(RequestParameter.class);
        if (requestParameter != null && !CommonsUtils.isBlank((String)requestParameter.value())) {
            name = requestParameter.value();
        }
        if ((activationContextParameter = parameter.getAnnotation(ActivationContextParameter.class)) != null && !CommonsUtils.isBlank((String)activationContextParameter.value())) {
            name = activationContextParameter.value();
        }
        if (CommonsUtils.isBlank((String)name)) {
            name = parameter.getName();
        }
        return name;
    }

    private void processResponses(Method method, String uri, String httpMethod, JSONObject methodDescription) {
        JSONObject responses = new JSONObject();
        JSONObject defaultResponse = new JSONObject();
        int statusCode = httpMethod.equals("post") || httpMethod.equals("put") ? 201 : 200;
        this.putIfNotEmpty(defaultResponse, "description", this.getValue(method, uri, httpMethod, statusCode));
        responses.put(String.valueOf(statusCode), (Object)defaultResponse);
        String[] produces = this.getProducedMediaTypes(method);
        if (produces != null && produces.length > 0) {
            JSONObject contentDescription = new JSONObject();
            for (String mediaType : produces) {
                JSONObject responseTypeDescription = new JSONObject();
                this.typeDescriber.describeReturnType(responseTypeDescription, method);
                contentDescription.put(mediaType, (Object)responseTypeDescription);
            }
            defaultResponse.put("content", (Object)contentDescription);
        }
        methodDescription.put("responses", (Object)responses);
    }

    private String[] getProducedMediaTypes(Method method) {
        String[] produces = CommonsUtils.EMPTY_STRING_ARRAY;
        RestInfo restInfo = method.getAnnotation(RestInfo.class);
        if (this.isNonEmptyConsumes(restInfo)) {
            produces = restInfo.produces();
        } else {
            restInfo = method.getDeclaringClass().getAnnotation(RestInfo.class);
            if (this.isNonEmptyProduces(restInfo)) {
                produces = restInfo.produces();
            }
        }
        return produces;
    }

    private void addElementsIfNotPresent(JSONArray accumulator, JSONArray array) {
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject method = array.getJSONObject(i);
                boolean present = this.isPresent(accumulator, method);
                if (present) continue;
                accumulator.add((Object)method);
            }
        }
    }

    private boolean isNonEmptyConsumes(RestInfo restInfo) {
        return restInfo != null && (restInfo.produces().length != 1 || !"".equals(restInfo.produces()[0]));
    }

    private boolean isNonEmptyProduces(RestInfo restInfo) {
        return restInfo != null && (restInfo.produces().length != 1 || !"".equals(restInfo.produces()[0]));
    }

    private boolean isPresent(JSONArray array, JSONObject object) {
        boolean present = false;
        for (int i = 0; i < array.size(); ++i) {
            if (!object.equals((Object)array.getJSONObject(i))) continue;
            present = false;
        }
        return present;
    }

    private Optional<String> getValue(Class<?> clazz, String property) {
        Optional<String> value = this.getValue(KEY_PREFIX + clazz.getName() + "." + property);
        if (!value.isPresent()) {
            value = this.getValue(KEY_PREFIX + clazz.getSimpleName() + "." + property);
        }
        return value;
    }

    private Optional<String> getValue(Method method, String path, String httpMethod, String property) {
        return this.getValue(method, path + "." + httpMethod + "." + property, false);
    }

    public Optional<String> getValue(Method method, String path, String httpMethod, Parameter parameter, String property) {
        return this.getValue(method, path, httpMethod, "parameter." + this.getParameterName(parameter), property);
    }

    public Optional<String> getValue(Method method, String path, String httpMethod, int statusCode) {
        return this.getValue(method, path, httpMethod, "response", String.valueOf(statusCode));
    }

    public Optional<String> getValue(Method method, String path, String httpMethod, String middle, String propertyName) {
        Optional<String> value = this.getValue(method, path + "." + httpMethod + "." + middle + "." + String.valueOf(propertyName), true);
        if (!value.isPresent()) {
            value = this.getValue(method, httpMethod + "." + middle + "." + propertyName, false);
        }
        if (!value.isPresent()) {
            value = this.getValue(method, middle + "." + propertyName, false);
        }
        if (!value.isPresent()) {
            value = this.getValue(middle + "." + propertyName);
        }
        return value;
    }

    public Optional<String> getValue(Method method, String suffix, boolean skipClassNameLookup) {
        Optional<String> value = Optional.empty();
        if (!skipClassNameLookup && !(value = this.getValue(KEY_PREFIX + method.getDeclaringClass().getName() + "." + suffix)).isPresent()) {
            value = this.getValue(KEY_PREFIX + method.getDeclaringClass().getSimpleName() + "." + suffix);
        }
        if (!value.isPresent()) {
            value = this.getValue(KEY_PREFIX + suffix);
        }
        return value;
    }

    private List<Method> toMethods(JSONArray methodsAsJson, Class<?> pageClass) throws NoSuchMethodException, SecurityException {
        ArrayList<Method> methods = new ArrayList<Method>(methodsAsJson.size());
        for (Object object : methodsAsJson) {
            JSONObject methodAsJason = (JSONObject)object;
            String name = methodAsJason.getString("name");
            JSONArray parametersAsJson = methodAsJason.getJSONArray("parameters");
            List<Class> parameterTypes = parametersAsJson.stream().map(o -> (String)o).map(s -> this.toClass((String)s)).collect(Collectors.toList());
            methods.add(this.findMethod(pageClass, name, parameterTypes));
        }
        return methods;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Method findMethod(Class<?> pageClass, String name, List<Class> parameterTypes) throws NoSuchMethodException {
        Method method = null;
        try {
            method = pageClass.getDeclaredMethod(name, parameterTypes.toArray(new Class[parameterTypes.size()]));
        }
        catch (NoSuchMethodException e) {
            Class clazz;
            ArrayList superTypes = new ArrayList();
            superTypes.add(pageClass.getSuperclass());
            superTypes.addAll(Arrays.asList(pageClass.getInterfaces()));
            Iterator iterator = superTypes.iterator();
            while (iterator.hasNext() && ((clazz = (Class)iterator.next()) == null || clazz.equals(Object.class) || (method = this.findMethod(clazz, name, parameterTypes)) == null)) {
            }
        }
        if (method == null && pageClass.getName().equals("org.apache.tapestry5.integration.app1.pages.rest.RestTypeDescriptionsDemo")) {
            System.out.println("WTF!");
        }
        return method;
    }

    private Class<?> toClass(String string) {
        Class<?> clasz = this.stringToClassMap.get(string);
        if (clasz == null) {
            try {
                clasz = Thread.currentThread().getContextClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.stringToClassMap.put(string, clasz);
        }
        return clasz;
    }

    private String getPath(Method method, Class<?> pageClass) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.pageRenderLinkSource.createPageRenderLink(pageClass).toString());
        for (Parameter parameter : method.getParameters()) {
            if (DefaultOpenApiDescriptionGenerator.isIgnored(parameter)) continue;
            builder.append("/");
            StaticActivationContextValue staticValue = parameter.getAnnotation(StaticActivationContextValue.class);
            if (staticValue != null) {
                builder.append(staticValue.value());
                continue;
            }
            builder.append("{");
            builder.append(this.getParameterName(parameter));
            builder.append("}");
        }
        String path = builder.toString();
        if (!path.startsWith(this.basePath)) {
            throw new RuntimeException(String.format("Method %s has path %s, which doesn't start with base path %s. It's likely you need to adjust the base path and/or the endpoint paths", method, path, this.basePath));
        }
        path = path.substring(this.basePath.length() - 1);
        path = path.replace("//", "/");
        return path;
    }

    private static boolean isIgnored(Parameter parameter) {
        boolean ignored = false;
        for (Class<?> clazz : InternalConstants.INJECTED_PARAMETERS) {
            if (parameter.getAnnotation(clazz) == null) continue;
            ignored = true;
            break;
        }
        return ignored;
    }

    private void putIfNotEmpty(JSONObject object, String propertyName, Optional<String> value) {
        value.ifPresent(v -> object.put(propertyName, v));
    }

    private void putIfNotEmpty(JSONObject object, String propertyName, String key) {
        this.getValue(key).ifPresent(value -> object.put(propertyName, value));
    }

    private Optional<String> getValue(String key) {
        Optional<String> value = this.getValueFromMessages(key);
        return value.isPresent() ? value : this.getValueFromSymbol(key);
    }

    private Optional<String> getValueFromMessages(String key) {
        this.logMessageLookup(key);
        String value = this.messages.get().get(key.replace("tapestry.", "")).trim();
        return value.startsWith("[") && value.endsWith("]") ? Optional.empty() : Optional.of(value);
    }

    private void logSymbolLookup(String key) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Looking up symbol  " + key);
        }
    }

    private void logMessageLookup(String key) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Looking up message " + key);
        }
    }

    private Optional<String> getValueFromSymbol(String key) {
        return this.getValueFromSymbolNoPrefix("tapestry." + key);
    }

    private Optional<String> getValueFromSymbolNoPrefix(String symbol) {
        String value;
        this.logSymbolLookup(symbol);
        try {
            value = this.symbolSource.valueForSymbol(symbol);
        }
        catch (RuntimeException e) {
            value = null;
        }
        return Optional.ofNullable(value);
    }

    private static String getHttpMethod(Method method) {
        OnEvent onEvent = method.getAnnotation(OnEvent.class);
        String httpMethod = onEvent != null ? onEvent.value() : method.getName().replace("on", "");
        httpMethod = httpMethod.toLowerCase();
        httpMethod = httpMethod.replace(PREFIX, "");
        return httpMethod;
    }

    private static boolean hasRestEndpoint(Page page) {
        return DefaultOpenApiDescriptionGenerator.hasRestEndpoint(page.getRootComponent());
    }

    private static boolean hasRestEndpoint(Component component) {
        ComponentModel componentModel = component.getComponentResources().getComponentModel();
        return "true".equals(componentModel.getMeta("restEndpointEventHandlerMethodsPresent"));
    }

    private void generateSchemas(JSONObject documentation) {
        if (!this.entities.isEmpty()) {
            JSONObject components = new JSONObject();
            JSONObject schemas = new JSONObject();
            for (Class<?> entity : this.entities) {
                this.typeDescriber.describeSchema(entity, schemas);
            }
            components.put("schemas", (Object)schemas);
            documentation.put("components", (Object)components);
        }
    }
}

