/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.ioc.services.UpdateListener;
import org.apache.tapestry5.ioc.services.UpdateListenerHub;

public class ResourceChangeTrackerImpl
extends InvalidationEventHubImpl
implements ResourceChangeTracker,
UpdateListener {
    private final URLChangeTracker tracker;
    private final long fixedLastModifiedTime = Math.round((double)System.currentTimeMillis() / 1000.0) * 1000L;

    public ResourceChangeTrackerImpl(ClasspathURLConverter classpathURLConverter, @Symbol(value="tapestry.production-mode") boolean productionMode) {
        super(productionMode);
        this.tracker = productionMode ? null : new URLChangeTracker(classpathURLConverter, true, false);
    }

    @PostInjection
    public void registerWithUpdateListenerHub(UpdateListenerHub hub) {
        hub.addUpdateListener((UpdateListener)this);
    }

    @Override
    public long trackResource(Resource resource) {
        if (this.tracker == null) {
            return this.fixedLastModifiedTime;
        }
        return this.tracker.add(resource.toURL());
    }

    @Override
    public void addDependency(Resource dependency) {
        this.trackResource(dependency);
    }

    @Override
    public void forceInvalidationEvent() {
        this.fireInvalidationEvent();
        if (this.tracker != null) {
            this.tracker.clear();
        }
    }

    public void checkForUpdates() {
        if (this.tracker.containsChanges()) {
            this.forceInvalidationEvent();
        }
    }
}

