/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.compatibility.Compatibility;
import org.apache.tapestry5.services.compatibility.Trait;

public class GridPager {
    @Parameter(required=true)
    private GridDataSource source;
    @Parameter(required=true)
    private int rowsPerPage;
    @Parameter(required=true)
    private int currentPage;
    @Parameter(value="symbol:tapestry.components.gridpager_page_range")
    private int range;
    @Parameter
    private String zone;
    private int lastIndex;
    private int maxPages;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Inject
    private Request request;
    @Inject
    private Compatibility compatibility;

    void beginRender(MarkupWriter writer) {
        int i;
        int availableRows = this.source.getAvailableRows();
        this.maxPages = (availableRows - 1) / this.rowsPerPage + 1;
        if (this.maxPages < 2) {
            return;
        }
        writer.element("ul", "class", "pagination");
        if (this.zone != null) {
            writer.attributes("data-inplace-grid-links", true);
        }
        this.lastIndex = 0;
        for (int i2 = 1; i2 <= 2; ++i2) {
            this.writePageLink(writer, i2);
        }
        int low = this.currentPage - this.range;
        int high = this.currentPage + this.range;
        if (low < 1) {
            low = 1;
            high = 2 * this.range + 1;
        } else if (high > this.maxPages) {
            high = this.maxPages;
            low = high - 2 * this.range;
        }
        for (i = low; i <= high; ++i) {
            this.writePageLink(writer, i);
        }
        for (i = this.maxPages - 1; i <= this.maxPages; ++i) {
            this.writePageLink(writer, i);
        }
        writer.end();
    }

    private void writePageLink(MarkupWriter writer, int pageIndex) {
        if (pageIndex < 1 || pageIndex > this.maxPages) {
            return;
        }
        if (pageIndex <= this.lastIndex) {
            return;
        }
        boolean isBootstrap4 = this.isBootstrap4();
        if (pageIndex != this.lastIndex + 1) {
            writer.element("li", "class", isBootstrap4 ? "disabled page-item" : "disabled");
            writer.element("a", "href", "#", "aria-disabled", "true");
            this.addClassAttributeToPageLinkIfNeeded(writer, isBootstrap4);
            writer.write(" ... ");
            writer.end();
            writer.end();
        }
        this.lastIndex = pageIndex;
        if (pageIndex == this.currentPage) {
            writer.element("li", "aria-current", "page", "class", isBootstrap4 ? "active page-item" : "active");
            writer.element("a", "href", "#", "aria-disabled", "true");
            this.addClassAttributeToPageLinkIfNeeded(writer, isBootstrap4);
            writer.write(Integer.toString(pageIndex));
            writer.end();
            writer.end();
            return;
        }
        writer.element("li", new Object[0]);
        if (isBootstrap4) {
            writer.getElement().attribute("class", "page-item");
        }
        Link link = this.resources.createEventLink("action", pageIndex);
        if (this.zone != null) {
            link.addParameter("t:inplace", "true");
        }
        writer.element("a", "href", link, "data-update-zone", this.zone, "title", this.messages.format("core-goto-page", new Object[]{pageIndex}));
        this.addClassAttributeToPageLinkIfNeeded(writer, isBootstrap4);
        writer.write(Integer.toString(pageIndex));
        writer.end();
        writer.end();
    }

    private void addClassAttributeToPageLinkIfNeeded(MarkupWriter writer, boolean isBootstrap4) {
        if (isBootstrap4) {
            writer.getElement().attribute("class", "page-link");
        }
    }

    boolean onAction(int newPage) {
        this.currentPage = newPage;
        if (this.request.isXHR()) {
            this.resources.triggerEvent("inplaceupdate", null, null);
        }
        return true;
    }

    protected boolean isBootstrap4() {
        return this.compatibility.enabled(Trait.BOOTSTRAP_4);
    }
}

