/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.pages;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.UnknownActivationContextCheck;
import org.apache.tapestry5.annotations.WhitelistAccessOnly;
import org.apache.tapestry5.beaneditor.Validate;
import org.apache.tapestry5.beanmodel.BeanModel;
import org.apache.tapestry5.beanmodel.services.BeanModelSource;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.func.Reducer;
import org.apache.tapestry5.internal.PageCatalogTotals;
import org.apache.tapestry5.internal.services.PageSource;
import org.apache.tapestry5.internal.services.ReloadHelper;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;

@UnknownActivationContextCheck(value=false)
@WhitelistAccessOnly
public class PageCatalog {
    @Property
    private PageCatalogTotals totals;
    @Property
    @Inject
    @Symbol(value="tapestry.production-mode")
    private boolean productionMode;
    @Inject
    private PageSource pageSource;
    @Inject
    private ComponentResourceSelector selector;
    @Inject
    private ComponentClassResolver resolver;
    @Inject
    private AlertManager alertManager;
    @Property
    private Page page;
    @InjectComponent
    private Zone pagesZone;
    @Persist
    private Set<String> failures;
    @Property
    @Validate(value="required")
    @Persist
    private String pageName;
    @Inject
    private OperationTracker operationTracker;
    @Inject
    private ReloadHelper reloadHelper;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private Messages messages;
    @Property
    public static BeanModel<Page> model;

    void pageLoaded() {
        model = this.beanModelSource.createDisplayModel(Page.class, this.messages);
        model.addExpression("selector", "selector.toString()");
        model.addExpression("assemblyTime", "stats.assemblyTime");
        model.addExpression("componentCount", "stats.componentCount");
        model.addExpression("weight", "stats.weight");
        model.reorder(new String[]{"name", "selector", "assemblyTime", "componentCount", "weight"});
    }

    public void onRecomputeTotals() {
        this.totals = new PageCatalogTotals();
        Flow pages = F.flow(this.getPages());
        this.totals.loadedPages = pages.count();
        this.totals.definedPages = this.getPageNames().size();
        this.totals.uniquePageNames = pages.map((Mapper)new Mapper<Page, String>(){

            public String map(Page element) {
                return element.getName();
            }
        }).toSet().size();
        this.totals.components = (Integer)pages.reduce((Reducer)new Reducer<Integer, Page>(){

            public Integer reduce(Integer accumulator, Page element) {
                return accumulator + element.getStats().componentCount;
            }
        }, (Object)0);
        Set selectorIds = pages.map((Mapper)new Mapper<Page, String>(){

            public String map(Page element) {
                return element.getSelector().toShortString();
            }
        }).toSet();
        this.totals.selectors = InternalUtils.joinSorted((Collection)selectorIds);
    }

    public List<String> getPageNames() {
        return this.resolver.getPageNames();
    }

    public Collection<Page> getPages() {
        return this.pageSource.getAllPages();
    }

    Object onSuccessFromSinglePageLoad() {
        boolean found;
        boolean bl = found = !((Flow)F.flow(this.getPages()).filter((Predicate)new Predicate<Page>(){

            public boolean accept(Page element) {
                return element.getName().equals(PageCatalog.this.pageName) && element.getSelector().equals(PageCatalog.this.selector);
            }
        })).isEmpty();
        if (found) {
            this.alertManager.warn(String.format("Page %s has already been loaded for '%s'.", this.pageName, this.selector.toShortString()));
            return null;
        }
        long startTime = System.currentTimeMillis();
        this.pageSource.getPage(this.pageName);
        this.alertManager.info(String.format("Loaded page %s for selector '%s' (in %,d ms).", this.pageName, this.selector.toShortString(), System.currentTimeMillis() - startTime));
        return this.pagesZone.getBody();
    }

    Object onActionFromForceLoad() {
        if (this.failures == null) {
            this.failures = CollectionFactory.newSet();
        }
        long startTime = System.currentTimeMillis();
        final Collection<Page> initialPages = this.getPages();
        final PageLoadData data = new PageLoadData();
        for (final String name : this.resolver.getPageNames()) {
            if (this.failures.contains(name)) {
                this.alertManager.warn(String.format("Skipping page %s due to prior load failure.", name));
                data.someFail = true;
                continue;
            }
            this.operationTracker.run("Loading page " + name, new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            Page newPage = PageCatalog.this.pageSource.getPage(name);
                            if (!initialPages.contains(newPage)) {
                                ++data.loadedCount;
                            }
                        }
                        catch (RuntimeException ex) {
                            PageCatalog.this.alertManager.error(String.format("Page %s failed to load.", name));
                            PageCatalog.this.failures.add(name);
                            if (data.fail != null) break block3;
                            PageCatalog.this.pageName = name;
                            data.fail = ex;
                        }
                    }
                }
            });
            if (data.fail == null) continue;
            break;
        }
        this.alertManager.info(String.format("Loaded %,d new pages for selector '%s' (in %,d ms).", data.loadedCount, this.selector.toShortString(), System.currentTimeMillis() - startTime));
        if (data.someFail) {
            this.alertManager.warn("Clear the cache to reset the list of failed pages.");
        }
        if (data.fail != null) {
            throw data.fail;
        }
        return this.pagesZone.getBody();
    }

    Object onActionFromClearCaches() {
        this.reloadHelper.forceReload();
        this.failures = null;
        return this.pagesZone.getBody();
    }

    Object onActionFromRunGC() {
        Runtime runtime = Runtime.getRuntime();
        long initialFreeMemory = runtime.freeMemory();
        runtime.gc();
        long delta = runtime.freeMemory() - initialFreeMemory;
        this.alertManager.info(String.format("Garbage collection freed %,.2f Kb of memory.", (double)delta / 1024.0));
        return this.pagesZone.getBody();
    }

    public String formatElapsed(double millis) {
        return String.format("%,.3f ms", millis);
    }

    private class PageLoadData {
        int loadedCount;
        RuntimeException fail;
        boolean someFail;

        private PageLoadData() {
        }
    }
}

