/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.ioc.annotations.Inject;

public class GridPager {
    @Parameter(required=true)
    private GridDataSource source;
    @Parameter(required=true)
    private int rowsPerPage;
    @Parameter(required=true)
    private int currentPage;
    @Parameter(value="symbol:tapestry.components.gridpager_page_range")
    private int range;
    @Parameter
    private String zone;
    private int lastIndex;
    private int maxPages;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Inject
    private Request request;

    void beginRender(MarkupWriter writer) {
        int i;
        int availableRows = this.source.getAvailableRows();
        this.maxPages = (availableRows - 1) / this.rowsPerPage + 1;
        if (this.maxPages < 2) {
            return;
        }
        writer.element("ul", "class", "pagination");
        if (this.zone != null) {
            writer.attributes("data-inplace-grid-links", true);
        }
        this.lastIndex = 0;
        for (int i2 = 1; i2 <= 2; ++i2) {
            this.writePageLink(writer, i2);
        }
        int low = this.currentPage - this.range;
        int high = this.currentPage + this.range;
        if (low < 1) {
            low = 1;
            high = 2 * this.range + 1;
        } else if (high > this.maxPages) {
            high = this.maxPages;
            low = high - 2 * this.range;
        }
        for (i = low; i <= high; ++i) {
            this.writePageLink(writer, i);
        }
        for (i = this.maxPages - 1; i <= this.maxPages; ++i) {
            this.writePageLink(writer, i);
        }
        writer.end();
    }

    private void writePageLink(MarkupWriter writer, int pageIndex) {
        if (pageIndex < 1 || pageIndex > this.maxPages) {
            return;
        }
        if (pageIndex <= this.lastIndex) {
            return;
        }
        if (pageIndex != this.lastIndex + 1) {
            writer.element("li", "class", "disabled");
            writer.element("a", "href", "#");
            writer.write(" ... ");
            writer.end();
            writer.end();
        }
        this.lastIndex = pageIndex;
        if (pageIndex == this.currentPage) {
            writer.element("li", "class", "active");
            writer.element("a", "href", "#");
            writer.write(Integer.toString(pageIndex));
            writer.end();
            writer.end();
            return;
        }
        writer.element("li", new Object[0]);
        Link link = this.resources.createEventLink("action", pageIndex);
        if (this.zone != null) {
            link.addParameter("t:inplace", "true");
        }
        Element element = writer.element("a", "href", link, "data-update-zone", this.zone, "title", this.messages.format("core-goto-page", new Object[]{pageIndex}));
        writer.write(Integer.toString(pageIndex));
        writer.end();
        writer.end();
    }

    boolean onAction(int newPage) {
        this.currentPage = newPage;
        if (this.request.isXHR()) {
            this.resources.triggerEvent("inplaceupdate", null, null);
        }
        return true;
    }
}

