/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.base;

import java.io.Serializable;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.ValidationDecorator;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Mixin;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.corelib.mixins.DiscardBody;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.BeanValidationContext;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.services.FormControlNameManager;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public abstract class AbstractField
implements Field {
    @Parameter(defaultPrefix="literal")
    protected String label;
    @Parameter(value="false")
    protected boolean disabled;
    @Mixin
    private DiscardBody discardBody;
    @Environmental
    protected ValidationDecorator decorator;
    @Inject
    protected Environment environment;
    @Inject
    @Symbol(value="tapestry.form-field-css-class")
    protected String cssClass;
    private static final ProcessSubmission PROCESS_SUBMISSION_ACTION = new ProcessSubmission();
    @Parameter(defaultPrefix="literal")
    private String clientId;
    @Parameter
    private boolean ensureClientIdUnique;
    private String assignedClientId;
    private String controlName;
    @Environmental(value=false)
    protected FormSupport formSupport;
    @Environmental
    protected JavaScriptSupport javaScriptSupport;
    @Environmental
    protected ValidationTracker validationTracker;
    @Inject
    protected ComponentResources resources;
    @Inject
    protected ComponentDefaultProvider defaultProvider;
    @Inject
    protected Request request;
    @Inject
    protected FieldValidationSupport fieldValidationSupport;
    @Inject
    private FormControlNameManager formControlNameManager;
    private boolean beanValidationDisabled = false;

    final String defaultLabel() {
        return this.defaultProvider.defaultLabel(this.resources);
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @SetupRender
    final void setup() {
        if (this.formSupport == null) {
            throw new RuntimeException(String.format("Component %s must be enclosed by a Form component.", this.resources.getCompleteId()));
        }
        this.assignedClientId = this.allocateClientId();
        String controlName = this.formSupport.allocateControlName(this.assignedClientId);
        this.formSupport.storeAndExecute(this, new Setup(controlName));
        this.formSupport.store(this, PROCESS_SUBMISSION_ACTION);
    }

    private String allocateClientId() {
        if (this.clientId == null) {
            return this.javaScriptSupport.allocateClientId(this.resources);
        }
        if (this.ensureClientIdUnique) {
            return this.javaScriptSupport.allocateClientId(this.clientId);
        }
        if (this.formControlNameManager.isReserved(this.clientId)) {
            throw new TapestryException(String.format("The value '%s' for parameter clientId is not allowed as it causes a naming conflict in the client-side DOM. Select an id not in the list: %s.", this.clientId, InternalUtils.joinSorted(this.formControlNameManager.getReservedNames())), (Object)this, null);
        }
        return this.clientId;
    }

    @Override
    public final String getClientId() {
        return this.assignedClientId;
    }

    @Override
    public final String getControlName() {
        return this.controlName;
    }

    @Override
    public final boolean isDisabled() {
        return this.disabled;
    }

    private void setupControlName(String controlName) {
        this.controlName = controlName;
    }

    private void processSubmission() {
        if (!this.disabled) {
            this.processSubmission(this.controlName);
        }
    }

    protected abstract void processSubmission(String var1);

    @BeginRender
    final void beforeDecorator() {
        this.decorator.beforeField(this);
    }

    @AfterRender
    final void afterDecorator() {
        this.decorator.afterField(this);
        String error = this.validationTracker.getError(this);
        if (error != null) {
            this.javaScriptSupport.require("t5/core/fields").invoke("showValidationError").with(this.assignedClientId, error);
        }
    }

    protected final void decorateInsideField() {
        this.decorator.insideField(this);
    }

    protected final void setDecorator(ValidationDecorator decorator) {
        this.decorator = decorator;
    }

    protected final void setFormSupport(FormSupport formSupport) {
        this.formSupport = formSupport;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    protected void putPropertyNameIntoBeanValidationContext(String parameterName) {
        if (this.beanValidationDisabled) {
            return;
        }
        String propertyName = ((InternalComponentResources)this.resources).getPropertyName(parameterName);
        BeanValidationContext beanValidationContext = this.environment.peek(BeanValidationContext.class);
        if (beanValidationContext == null) {
            return;
        }
        if (beanValidationContext.getCurrentProperty() == null) {
            beanValidationContext.setCurrentProperty(propertyName);
        }
    }

    protected void removePropertyNameFromBeanValidationContext() {
        if (this.beanValidationDisabled) {
            return;
        }
        BeanValidationContext beanValidationContext = this.environment.peek(BeanValidationContext.class);
        if (beanValidationContext == null) {
            return;
        }
        beanValidationContext.setCurrentProperty(null);
    }

    static class ProcessSubmission
    implements ComponentAction<AbstractField>,
    Serializable {
        private static final long serialVersionUID = -4346426414137434418L;

        ProcessSubmission() {
        }

        @Override
        public void execute(AbstractField component) {
            component.processSubmission();
        }

        public String toString() {
            return "AbstractField.ProcessSubmission";
        }
    }

    static class Setup
    implements ComponentAction<AbstractField>,
    Serializable {
        private static final long serialVersionUID = 2690270808212097020L;
        private final String controlName;

        public Setup(String controlName) {
            this.controlName = controlName;
        }

        @Override
        public void execute(AbstractField component) {
            component.setupControlName(this.controlName);
        }

        public String toString() {
            return String.format("AbstractField.Setup[%s]", this.controlName);
        }
    }
}

