/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.hibernate.web.modules;

import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.commons.Configuration;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.OrderedConfiguration;
import org.apache.tapestry5.commons.services.PropertyAccess;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.apache.tapestry5.hibernate.HibernateCore;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.hibernate.web.internal.CommitAfterWorker;
import org.apache.tapestry5.hibernate.web.internal.EntityApplicationStatePersistenceStrategy;
import org.apache.tapestry5.hibernate.web.internal.EntityPersistentFieldStrategy;
import org.apache.tapestry5.hibernate.web.internal.HibernateEntityValueEncoder;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.ServiceOverride;
import org.apache.tapestry5.services.ApplicationStateContribution;
import org.apache.tapestry5.services.ApplicationStatePersistenceStrategy;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.services.PersistentFieldStrategy;
import org.apache.tapestry5.services.ValueEncoderFactory;
import org.apache.tapestry5.services.dashboard.DashboardManager;
import org.apache.tapestry5.services.dashboard.DashboardTab;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.hibernate.Session;
import org.hibernate.metadata.ClassMetadata;

public class HibernateModule {
    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"tapestry.hibernate.provide-entity-value-encoders", (Object)"true");
        configuration.add((Object)"tapestry.hibernate.entity-session-state-persistence-strategy-enabled", (Object)"false");
    }

    public static void contributeHibernateEntityPackageManager(Configuration<String> configuration, @Symbol(value="tapestry.app-package") String appRootPackage) {
        configuration.add((Object)(appRootPackage + ".entities"));
    }

    @Contribute(value=ServiceOverride.class)
    public static void provideInjectableSessionObject(MappedConfiguration<Class, Object> configuration, @HibernateCore Session session) {
        configuration.add(Session.class, (Object)session);
    }

    public static void contributeValueEncoderSource(MappedConfiguration<Class, ValueEncoderFactory> configuration, @Symbol(value="tapestry.hibernate.provide-entity-value-encoders") boolean provideEncoders, HibernateSessionSource sessionSource, final Session session, final TypeCoercer typeCoercer, final PropertyAccess propertyAccess, final LoggerSource loggerSource) {
        if (!provideEncoders) {
            return;
        }
        for (ClassMetadata classMetadata : sessionSource.getSessionFactory().getAllClassMetadata().values()) {
            final Class entityClass = classMetadata.getMappedClass();
            final String idenfierPropertyName = classMetadata.getIdentifierPropertyName();
            if (entityClass == null) continue;
            ValueEncoderFactory factory = new ValueEncoderFactory(){

                public ValueEncoder create(Class type) {
                    return new HibernateEntityValueEncoder(entityClass, idenfierPropertyName, session, propertyAccess, typeCoercer, loggerSource.getLogger(entityClass));
                }
            };
            configuration.add((Object)entityClass, (Object)factory);
        }
    }

    public static void contributePersistentFieldManager(MappedConfiguration<String, PersistentFieldStrategy> configuration) {
        configuration.addInstance((Object)"entity", EntityPersistentFieldStrategy.class);
    }

    public void contributeApplicationStatePersistenceStrategySource(MappedConfiguration<String, ApplicationStatePersistenceStrategy> configuration) {
        configuration.addInstance((Object)"entity", EntityApplicationStatePersistenceStrategy.class);
    }

    public static void contributeApplicationStateManager(MappedConfiguration<Class, ApplicationStateContribution> configuration, @Symbol(value="tapestry.hibernate.entity-session-state-persistence-strategy-enabled") boolean entitySessionStatePersistenceStrategyEnabled, HibernateSessionSource sessionSource) {
        if (!entitySessionStatePersistenceStrategyEnabled) {
            return;
        }
        for (ClassMetadata classMetadata : sessionSource.getSessionFactory().getAllClassMetadata().values()) {
            Class entityClass = classMetadata.getMappedClass();
            configuration.add((Object)entityClass, (Object)new ApplicationStateContribution("entity"));
        }
    }

    @Contribute(value=ComponentClassTransformWorker2.class)
    @Primary
    public static void provideCommitAfterAnnotationSupport(OrderedConfiguration<ComponentClassTransformWorker2> configuration) {
        configuration.addInstance("CommitAfter", CommitAfterWorker.class, new String[]{"after:Log"});
    }

    @Contribute(value=DashboardManager.class)
    public static void provideHibernateDashboardTab(OrderedConfiguration<DashboardTab> configuration) {
        configuration.add("HibernateStatistics", (Object)new DashboardTab("Hibernate", "hibernate/HibernateStatistics"), new String[]{"after:Services"});
    }

    @Contribute(value=ComponentClassResolver.class)
    public static void provideLibraryMapping(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping("hibernate", "org.apache.tapestry5.hibernate.web"));
    }
}

