/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.commons.util.UnknownValueException;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.internal.transform.ReadOnlyComponentFieldConduit;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class InjectComponentWorker
implements ComponentClassTransformWorker2 {
    private final ComponentClassCache classCache;

    public InjectComponentWorker(ComponentClassCache classCache) {
        this.classCache = classCache;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(InjectComponent.class)) {
            InjectComponent annotation = (InjectComponent)field.getAnnotation(InjectComponent.class);
            field.claim((Object)annotation);
            final String type = field.getTypeName();
            final String componentId = this.getComponentId(field, annotation);
            final String fieldName = field.getName();
            ComputedValue<FieldConduit<Object>> provider = new ComputedValue<FieldConduit<Object>>(){

                public FieldConduit<Object> get(InstanceContext context) {
                    ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                    return new InjectedComponentFieldValueConduit(resources, fieldName, type, componentId);
                }
            };
            field.setComputedConduit((ComputedValue)provider);
        }
    }

    private String getComponentId(PlasticField field, InjectComponent annotation) {
        String id = annotation.value();
        if (InternalUtils.isNonBlank((String)id)) {
            return id;
        }
        return InternalUtils.stripMemberName((String)field.getName());
    }

    private final class InjectedComponentFieldValueConduit
    extends ReadOnlyComponentFieldConduit {
        private final ComponentResources resources;
        private final String fieldName;
        private final String componentId;
        private final String type;
        private Component embedded;

        private InjectedComponentFieldValueConduit(ComponentResources resources, String fieldName, String type, String componentId) {
            super(resources, fieldName);
            this.resources = resources;
            this.fieldName = fieldName;
            this.componentId = componentId;
            this.type = type;
            resources.getPageLifecycleCallbackHub().addPageAttachedCallback(new Runnable(){

                @Override
                public void run() {
                    InjectedComponentFieldValueConduit.this.load();
                }
            });
        }

        private void load() {
            try {
                this.embedded = this.resources.getEmbeddedComponent(this.componentId);
            }
            catch (UnknownValueException ex) {
                throw new RuntimeException(String.format("Unable to inject component into field %s of class %s: %s", this.fieldName, this.getComponentClassName(), ex.getMessage()), ex);
            }
            Class fieldType = InjectComponentWorker.this.classCache.forName(this.type);
            if (!fieldType.isInstance(this.embedded)) {
                throw new RuntimeException(String.format("Unable to inject component '%s' into field %s of %s. Class %s is not assignable to a field of type %s.", this.componentId, this.fieldName, this.getComponentClassName(), this.embedded.getClass().getName(), fieldType.getName()));
            }
        }

        private String getComponentClassName() {
            return this.resources.getComponentModel().getComponentClassName();
        }

        public Object get(Object instance, InstanceContext context) {
            return this.embedded;
        }
    }
}

