/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.Adler32;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

public class AssetChecksumGeneratorImpl
implements AssetChecksumGenerator {
    private final StreamableResourceSource streamableResourceSource;
    private final ResourceChangeTracker tracker;
    private final Map<StreamableResource, String> cache = CollectionFactory.newConcurrentMap();

    public AssetChecksumGeneratorImpl(StreamableResourceSource streamableResourceSource, ResourceChangeTracker tracker) {
        this.streamableResourceSource = streamableResourceSource;
        this.tracker = tracker;
        tracker.clearOnInvalidation(this.cache);
    }

    @Override
    public String generateChecksum(Resource resource) throws IOException {
        StreamableResource streamable = this.streamableResourceSource.getStreamableResource(resource, StreamableResourceProcessing.COMPRESSION_DISABLED, this.tracker);
        return this.generateChecksum(streamable);
    }

    @Override
    public String generateChecksum(StreamableResource resource) throws IOException {
        String result = this.cache.get(resource);
        if (result == null) {
            result = this.toChecksum(resource.openStream());
            this.cache.put(resource, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toChecksum(InputStream is) throws IOException {
        Adler32 checksum = new Adler32();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) >= 0) {
                checksum.update(buffer, 0, length);
            }
            String string = Long.toHexString(checksum.getValue());
            return string;
        }
        finally {
            is.close();
        }
    }
}

