/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.AssetFactory;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ResponseCustomizer;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

public class ResourceStreamerImpl
implements ResourceStreamer {
    static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    private static final String QUOTE = "\"";
    private final Request request;
    private final Response response;
    private final StreamableResourceSource streamableResourceSource;
    private final boolean productionMode;
    private final OperationTracker tracker;
    private final ResourceChangeTracker resourceChangeTracker;
    private final String omitExpirationCacheControlHeader;
    private final AssetFactory classpathAssetFactory;
    private final AssetFactory contextAssetFactory;

    public ResourceStreamerImpl(Request request, Response response, StreamableResourceSource streamableResourceSource, OperationTracker tracker, @Symbol(value="tapestry.production-mode") boolean productionMode, ResourceChangeTracker resourceChangeTracker, @Symbol(value="tapestry.omit-expiration-cache-control-header") String omitExpirationCacheControlHeader, @InjectService(value="ClasspathAssetFactory") AssetFactory classpathAssetFactory, @InjectService(value="ContextAssetFactory") AssetFactory contextAssetFactory) {
        this.request = request;
        this.response = response;
        this.streamableResourceSource = streamableResourceSource;
        this.tracker = tracker;
        this.productionMode = productionMode;
        this.resourceChangeTracker = resourceChangeTracker;
        this.omitExpirationCacheControlHeader = omitExpirationCacheControlHeader;
        this.classpathAssetFactory = classpathAssetFactory;
        this.contextAssetFactory = contextAssetFactory;
    }

    @Override
    public boolean streamResource(final Resource resource, final String providedChecksum, final Set<ResourceStreamer.Options> options) throws IOException {
        if (!resource.exists()) {
            this.response.sendError(404, String.format("Unable to locate asset '%s' (the file does not exist).", resource));
            return true;
        }
        final boolean compress = providedChecksum.startsWith("z");
        return (Boolean)this.tracker.perform("Streaming " + resource + (compress ? " (compressed)" : ""), (IOOperation)new IOOperation<Boolean>(){

            public Boolean perform() throws IOException {
                StreamableResourceProcessing processing = compress ? StreamableResourceProcessing.COMPRESSION_ENABLED : StreamableResourceProcessing.COMPRESSION_DISABLED;
                StreamableResource streamable = ResourceStreamerImpl.this.streamableResourceSource.getStreamableResource(resource, processing, ResourceStreamerImpl.this.resourceChangeTracker);
                return ResourceStreamerImpl.this.streamResource(resource, streamable, compress ? providedChecksum.substring(1) : providedChecksum, options);
            }
        });
    }

    @Override
    public boolean streamResource(StreamableResource streamable, String providedChecksum, Set<ResourceStreamer.Options> options) throws IOException {
        return this.streamResource(null, streamable, providedChecksum, options);
    }

    public boolean streamResource(Resource resource, StreamableResource streamable, String providedChecksum, Set<ResourceStreamer.Options> options) throws IOException {
        ResponseCustomizer responseCustomizer;
        long ifModifiedSince;
        assert (streamable != null);
        assert (providedChecksum != null);
        assert (options != null);
        String actualChecksum = streamable.getChecksum();
        if (providedChecksum.length() > 0 && !providedChecksum.equals(actualChecksum)) {
            Asset asset = null;
            if (resource != null) {
                asset = this.findAssetInsideWebapp(resource);
            }
            if (asset != null) {
                this.response.sendRedirect(asset.toClientURL());
                return true;
            }
            return false;
        }
        String token = QUOTE + actualChecksum + QUOTE;
        this.response.setHeader("ETag", token);
        String providedToken = this.request.getHeader("If-None-Match");
        if (token.equals(providedToken)) {
            this.response.setStatus(304);
            return true;
        }
        long lastModified = streamable.getLastModified();
        try {
            ifModifiedSince = this.request.getDateHeader(IF_MODIFIED_SINCE_HEADER);
        }
        catch (IllegalArgumentException ex) {
            ifModifiedSince = -1L;
        }
        if (ifModifiedSince > 0L && ifModifiedSince >= lastModified) {
            this.response.setStatus(304);
            return true;
        }
        this.response.disableCompression();
        this.response.setDateHeader("Last-Modified", lastModified);
        if (this.productionMode && !options.contains((Object)ResourceStreamer.Options.OMIT_EXPIRATION)) {
            this.response.setDateHeader("Expires", lastModified + InternalConstants.TEN_YEARS);
        }
        if (options.contains((Object)ResourceStreamer.Options.OMIT_EXPIRATION)) {
            this.response.setHeader("Cache-Control", this.omitExpirationCacheControlHeader);
        }
        this.response.setContentLength(streamable.getSize());
        if (streamable.getCompression() == CompressionStatus.COMPRESSED) {
            this.response.setHeader("Content-Encoding", "gzip");
        }
        if ((responseCustomizer = streamable.getResponseCustomizer()) != null) {
            responseCustomizer.customizeResponse(streamable, this.response);
        }
        OutputStream os = this.response.getOutputStream(streamable.getContentType().toString());
        streamable.streamTo(os);
        os.close();
        return true;
    }

    private Asset findAssetInsideWebapp(Resource resource) {
        Asset asset = this.findAssetFromClasspath(resource);
        if (asset == null) {
            asset = this.findAssetFromContext(resource);
        }
        return asset;
    }

    private Asset findAssetFromContext(Resource resource) {
        Asset asset = null;
        try {
            asset = this.contextAssetFactory.createAsset(resource);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return asset;
    }

    private Asset findAssetFromClasspath(Resource resource) {
        Asset asset = null;
        try {
            asset = this.classpathAssetFactory.createAsset(resource);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return asset;
    }
}

