/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.services.ComponentModelSource;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.LinkCreationListener2;
import org.apache.tapestry5.services.PageRenderRequestParameters;

public class LinkDecorationListener
implements LinkCreationListener2 {
    private final ComponentClassResolver resolver;
    private final ComponentSource componentSource;
    private final ComponentModelSource modelSource;

    public LinkDecorationListener(ComponentClassResolver resolver, ComponentSource componentSource, ComponentModelSource modelSource) {
        this.resolver = resolver;
        this.componentSource = componentSource;
        this.modelSource = modelSource;
    }

    @Override
    public void createdComponentEventLink(Link link, ComponentEventRequestParameters parameters) {
        this.trigger(parameters.getActivePageName(), "decorateComponentEventLink", link, parameters);
    }

    @Override
    public void createdPageRenderLink(Link link, PageRenderRequestParameters parameters) {
        this.trigger(parameters.getLogicalPageName(), "decoratePageRenderLink", link, parameters);
    }

    private void trigger(String pageName, String eventType, Link link, Object parameters) {
        String pageClassName = this.resolver.resolvePageNameToClassName(pageName);
        ComponentModel model = this.modelSource.getModel(pageClassName);
        if (model.handlesEvent(eventType)) {
            Component page = this.componentSource.getPage(pageName);
            page.getComponentResources().triggerEvent(eventType, new Object[]{link, parameters}, null);
        }
    }
}

