/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.ajax;

import org.apache.tapestry5.ClientBodyElement;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.internal.services.PageRenderQueue;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.services.ajax.AjaxFormUpdateController;
import org.apache.tapestry5.internal.services.ajax.SingleZonePartialRendererFilter;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.PartialMarkupRendererFilter;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.ajax.AjaxResponseRenderer;
import org.apache.tapestry5.services.ajax.JSONCallback;
import org.apache.tapestry5.services.ajax.JavaScriptCallback;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class AjaxResponseRendererImpl
implements AjaxResponseRenderer {
    private final PageRenderQueue queue;
    private final AjaxFormUpdateController ajaxFormUpdateController;
    private final TypeCoercer typeCoercer;
    private final JavaScriptSupport javaScriptSupport;
    private final RequestPageCache requestPageCache;
    private final Request request;

    public AjaxResponseRendererImpl(PageRenderQueue queue, AjaxFormUpdateController ajaxFormUpdateController, TypeCoercer typeCoercer, JavaScriptSupport javaScriptSupport, RequestPageCache requestPageCache, Request request) {
        this.queue = queue;
        this.ajaxFormUpdateController = ajaxFormUpdateController;
        this.typeCoercer = typeCoercer;
        this.javaScriptSupport = javaScriptSupport;
        this.requestPageCache = requestPageCache;
        this.request = request;
    }

    @Override
    public AjaxResponseRenderer addRender(String clientId, Object renderer) {
        assert (InternalUtils.isNonBlank((String)clientId));
        assert (renderer != null);
        RenderCommand command = (RenderCommand)this.typeCoercer.coerce(renderer, RenderCommand.class);
        this.addFilter(new SingleZonePartialRendererFilter(clientId, command, this.queue, this.ajaxFormUpdateController));
        return this;
    }

    @Override
    public AjaxResponseRenderer addRender(ClientBodyElement zone) {
        assert (zone != null);
        String clientId = zone.getClientId();
        if (clientId == null) {
            throw new IllegalArgumentException("Attempt to render a ClientBodyElement, probably a Zone, with a null clientId. You can solve this by using the id parameter.");
        }
        this.addRender(clientId, zone.getBody());
        return this;
    }

    @Override
    public AjaxResponseRenderer addCallback(final JavaScriptCallback callback) {
        assert (callback != null);
        this.addFilter(new PartialMarkupRendererFilter(){

            @Override
            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer renderer) {
                renderer.renderMarkup(writer, reply);
                callback.run(AjaxResponseRendererImpl.this.javaScriptSupport);
            }
        });
        return this;
    }

    @Override
    public AjaxResponseRenderer addCallback(final Runnable callback) {
        assert (callback != null);
        this.addFilter(new PartialMarkupRendererFilter(){

            @Override
            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer renderer) {
                renderer.renderMarkup(writer, reply);
                callback.run();
            }
        });
        return this;
    }

    private boolean isRedirect(JSONObject reply) {
        return reply.has("_tapestry") && reply.in("_tapestry").has("redirectURL");
    }

    @Override
    public AjaxResponseRenderer addFilter(final PartialMarkupRendererFilter filter) {
        assert (filter != null);
        this.queue.addPartialMarkupRendererFilter(new PartialMarkupRendererFilter(){

            @Override
            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer delete) {
                if (AjaxResponseRendererImpl.this.isRedirect(reply)) {
                    delete.renderMarkup(writer, reply);
                    return;
                }
                filter.renderMarkup(writer, reply, delete);
            }
        });
        return this;
    }

    @Override
    public AjaxResponseRenderer addCallback(final JSONCallback callback) {
        assert (callback != null);
        this.addFilter(new PartialMarkupRendererFilter(){

            @Override
            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer renderer) {
                renderer.renderMarkup(writer, reply);
                callback.run(reply);
            }
        });
        return this;
    }

    @Override
    public void setupPartial(String pageName) {
        Page page = this.requestPageCache.get(pageName);
        this.queue.setRenderingPage(page);
        this.request.setAttribute("page-name", page.getName());
    }
}

