/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry5.internal.parser.ComponentTemplate;
import org.apache.tapestry5.internal.parser.TemplateToken;
import org.apache.tapestry5.internal.services.ComponentTemplateSource;
import org.apache.tapestry5.internal.services.ReloadHelper;
import org.apache.tapestry5.internal.services.TemplateParser;
import org.apache.tapestry5.internal.util.MultiKey;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.InvalidationEventHub;
import org.apache.tapestry5.services.UpdateListener;
import org.apache.tapestry5.services.UpdateListenerHub;
import org.apache.tapestry5.services.pageload.ComponentResourceLocator;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;

public final class ComponentTemplateSourceImpl
extends InvalidationEventHubImpl
implements ComponentTemplateSource,
UpdateListener {
    private final TemplateParser parser;
    private final URLChangeTracker tracker;
    private final ComponentResourceLocator locator;
    private final Map<MultiKey, Resource> templateResources = CollectionFactory.newConcurrentMap();
    private final Map<Resource, ComponentTemplate> templates = CollectionFactory.newConcurrentMap();
    private final ComponentTemplate missingTemplate = new ComponentTemplate(){

        @Override
        public Map<String, Location> getComponentIds() {
            return Collections.emptyMap();
        }

        @Override
        public Resource getResource() {
            return null;
        }

        @Override
        public List<TemplateToken> getTokens() {
            return Collections.emptyList();
        }

        @Override
        public boolean isMissing() {
            return true;
        }

        @Override
        public List<TemplateToken> getExtensionPointTokens(String extensionPointId) {
            return null;
        }

        @Override
        public boolean isExtension() {
            return false;
        }

        @Override
        public boolean usesStrictMixinParameters() {
            return false;
        }
    };

    public ComponentTemplateSourceImpl(@Inject @Symbol(value="tapestry.production-mode") boolean productionMode, TemplateParser parser, ComponentResourceLocator locator, ClasspathURLConverter classpathURLConverter) {
        this(productionMode, parser, locator, new URLChangeTracker(classpathURLConverter));
    }

    ComponentTemplateSourceImpl(boolean productionMode, TemplateParser parser, ComponentResourceLocator locator, URLChangeTracker tracker) {
        super(productionMode);
        this.parser = parser;
        this.locator = locator;
        this.tracker = tracker;
    }

    @PostInjection
    public void registerAsUpdateListener(UpdateListenerHub hub) {
        hub.addUpdateListener((UpdateListener)this);
    }

    @PostInjection
    public void setupReload(ReloadHelper helper) {
        helper.addReloadCallback(new Runnable(){

            @Override
            public void run() {
                ComponentTemplateSourceImpl.this.invalidate();
            }
        });
    }

    @Override
    public ComponentTemplate getTemplate(ComponentModel componentModel, ComponentResourceSelector selector) {
        ComponentTemplate result;
        String componentName = componentModel.getComponentClassName();
        MultiKey key = new MultiKey(new Object[]{componentName, selector});
        Resource resource = this.templateResources.get(key);
        if (resource == null) {
            resource = this.locateTemplateResource(componentModel, selector);
            this.templateResources.put(key, resource);
        }
        if ((result = this.templates.get(resource)) == null) {
            result = this.parseTemplate(resource);
            this.templates.put(resource, result);
        }
        return result;
    }

    public ComponentTemplate getTemplate(ComponentModel componentModel, Locale locale) {
        return this.getTemplate(componentModel, new ComponentResourceSelector(locale));
    }

    private ComponentTemplate parseTemplate(Resource r) {
        if (!r.exists()) {
            return this.missingTemplate;
        }
        this.tracker.add(r.toURL());
        return this.parser.parseTemplate(r);
    }

    private Resource locateTemplateResource(ComponentModel initialModel, ComponentResourceSelector selector) {
        for (ComponentModel model = initialModel; model != null; model = model.getParentModel()) {
            Resource localized = this.locator.locateTemplate(model, selector);
            if (localized == null) continue;
            return localized;
        }
        return initialModel.getBaseResource().withExtension("tml");
    }

    public void checkForUpdates() {
        if (this.tracker.containsChanges()) {
            this.invalidate();
        }
    }

    private void invalidate() {
        this.tracker.clear();
        this.templateResources.clear();
        this.templates.clear();
        this.fireInvalidationEvent();
    }

    @Override
    public InvalidationEventHub getInvalidationEventHub() {
        return this;
    }
}

