/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.internal.services.MessagesBundle;
import org.apache.tapestry5.internal.services.MessagesSourceImpl;
import org.apache.tapestry5.internal.services.ReloadHelper;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.InvalidationEventHub;
import org.apache.tapestry5.services.UpdateListener;
import org.apache.tapestry5.services.messages.ComponentMessagesSource;
import org.apache.tapestry5.services.messages.PropertiesFileParser;
import org.apache.tapestry5.services.pageload.ComponentResourceLocator;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;

public class ComponentMessagesSourceImpl
implements ComponentMessagesSource,
UpdateListener {
    private final MessagesSourceImpl messagesSource;
    private final MessagesBundle appCatalogBundle;

    public ComponentMessagesSourceImpl(@Symbol(value="tapestry.production-mode") boolean productionMode, List<Resource> appCatalogResources, PropertiesFileParser parser, ComponentResourceLocator resourceLocator, ClasspathURLConverter classpathURLConverter) {
        this(productionMode, appCatalogResources, resourceLocator, parser, new URLChangeTracker(classpathURLConverter));
    }

    ComponentMessagesSourceImpl(boolean productionMode, Resource appCatalogResource, ComponentResourceLocator resourceLocator, PropertiesFileParser parser, URLChangeTracker tracker) {
        this(productionMode, Arrays.asList(appCatalogResource), resourceLocator, parser, tracker);
    }

    ComponentMessagesSourceImpl(boolean productionMode, List<Resource> appCatalogResources, ComponentResourceLocator resourceLocator, PropertiesFileParser parser, URLChangeTracker tracker) {
        this.messagesSource = new MessagesSourceImpl(productionMode, productionMode ? null : tracker, resourceLocator, parser);
        this.appCatalogBundle = this.createAppCatalogBundle(appCatalogResources);
    }

    @PostInjection
    public void setupReload(ReloadHelper reloadHelper) {
        reloadHelper.addReloadCallback(new Runnable(){

            @Override
            public void run() {
                ComponentMessagesSourceImpl.this.messagesSource.invalidate();
            }
        });
    }

    public void checkForUpdates() {
        this.messagesSource.checkForUpdates();
    }

    @Override
    public Messages getMessages(ComponentModel componentModel, Locale locale) {
        return this.getMessages(componentModel, new ComponentResourceSelector(locale));
    }

    @Override
    public Messages getMessages(ComponentModel componentModel, ComponentResourceSelector selector) {
        ComponentModelBundle bundle = new ComponentModelBundle(componentModel);
        return this.messagesSource.getMessages(bundle, selector);
    }

    @Override
    public Messages getApplicationCatalog(Locale locale) {
        return this.messagesSource.getMessages(this.appCatalogBundle, new ComponentResourceSelector(locale));
    }

    private MessagesBundle createAppCatalogBundle(List<Resource> resources) {
        MessagesBundle current = null;
        for (Resource r : resources) {
            current = this.createMessagesBundle(r, current);
        }
        return current;
    }

    private MessagesBundle createMessagesBundle(final Resource resource, final MessagesBundle parent) {
        return new MessagesBundle(){

            @Override
            public Resource getBaseResource() {
                return resource;
            }

            @Override
            public Object getId() {
                return resource.getPath();
            }

            @Override
            public MessagesBundle getParent() {
                return parent;
            }
        };
    }

    @Override
    public InvalidationEventHub getInvalidationEventHub() {
        return this.messagesSource;
    }

    private class ComponentModelBundle
    implements MessagesBundle {
        private final ComponentModel model;

        public ComponentModelBundle(ComponentModel model) {
            this.model = model;
        }

        @Override
        public Resource getBaseResource() {
            return this.model.getBaseResource();
        }

        @Override
        public Object getId() {
            return this.model.getComponentClassName();
        }

        @Override
        public MessagesBundle getParent() {
            ComponentModel parentModel = this.model.getParentModel();
            if (parentModel == null) {
                return ComponentMessagesSourceImpl.this.appCatalogBundle;
            }
            return new ComponentModelBundle(parentModel);
        }
    }
}

