/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

class JSON {
    JSON() {
    }

    static double checkDouble(double d) throws RuntimeException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new RuntimeException("JSON does not allow non-finite numbers.");
        }
        return d;
    }

    static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if ("true".equalsIgnoreCase(stringValue)) {
                return true;
            }
            if ("false".equalsIgnoreCase(stringValue)) {
                return false;
            }
        }
        return null;
    }

    static Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static Integer toInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return (int)Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static Long toLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return (long)Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    static RuntimeException typeMismatch(boolean array, Object indexOrName, Object actual, String requiredType) throws RuntimeException {
        String location;
        String string = location = array ? "JSONArray[" + indexOrName + "]" : "JSONObject[\"" + indexOrName + "\"]";
        if (actual == null) {
            throw new RuntimeException(location + " is null.");
        }
        throw new RuntimeException(location + " is not a " + requiredType + ".");
    }

    static RuntimeException typeMismatch(Object actual, String requiredType) throws RuntimeException {
        if (actual == null) {
            throw new RuntimeException("Value is null.");
        }
        throw new RuntimeException("Value " + actual + " of type " + actual.getClass().getName() + " cannot be converted to " + requiredType);
    }
}

