/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.ioc.Resource;

public class ChecksumPath {
    private static final String NON_EXISTING_RESOURCE = "_________________________";
    public final String checksum;
    public final String resourcePath;
    private final ResourceStreamer streamer;

    public ChecksumPath(ResourceStreamer streamer, String baseFolder, String extraPath) {
        this.streamer = streamer;
        int slashx = extraPath.indexOf(47);
        this.checksum = slashx >= 0 ? extraPath.substring(0, slashx) : null;
        String morePath = extraPath.substring(slashx + 1);
        this.resourcePath = StringUtils.isNotBlank((CharSequence)morePath) ? (baseFolder == null ? morePath : baseFolder + "/" + morePath) : NON_EXISTING_RESOURCE;
    }

    public boolean stream(Resource resource) throws IOException {
        if (resource == null || !resource.exists()) {
            return false;
        }
        return this.streamer.streamResource(resource, this.checksum, ResourceStreamer.DEFAULT_OPTIONS);
    }
}

