/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.internal.services.ComponentResultProcessorWrapper;
import org.apache.tapestry5.internal.services.PageActivator;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.services.ComponentEventRequestHandler;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.Traditional;

public class ComponentEventRequestHandlerImpl
implements ComponentEventRequestHandler {
    private final ComponentEventResultProcessor resultProcessor;
    private final RequestPageCache cache;
    private final Response response;
    private final PageActivator pageActivator;
    private final Environment environment;

    public ComponentEventRequestHandlerImpl(@Traditional @Primary ComponentEventResultProcessor resultProcessor, RequestPageCache cache, Response response, PageActivator pageActivator, Environment environment) {
        this.resultProcessor = resultProcessor;
        this.cache = cache;
        this.response = response;
        this.pageActivator = pageActivator;
        this.environment = environment;
    }

    @Override
    public void handle(ComponentEventRequestParameters parameters) throws IOException {
        Page activePage = this.cache.get(parameters.getActivePageName());
        if (this.pageActivator.activatePage(activePage.getRootElement().getComponentResources(), parameters.getPageActivationContext(), this.resultProcessor)) {
            return;
        }
        Page containerPage = this.cache.get(parameters.getContainingPageName());
        ComponentResultProcessorWrapper callback = new ComponentResultProcessorWrapper(this.resultProcessor);
        this.environment.push(ComponentEventResultProcessor.class, this.resultProcessor);
        this.environment.push(TrackableComponentEventCallback.class, callback);
        ComponentPageElement element = containerPage.getComponentElementByNestedId(parameters.getNestedComponentId());
        boolean handled = element.triggerContextEvent(parameters.getEventType(), parameters.getEventContext(), callback);
        if (!handled) {
            throw new TapestryException(String.format("Request event '%s' (on component %s) was not handled; you must provide a matching event handler method in the component or in one of its containers.", parameters.getEventType(), element.getCompleteId()), (Object)element, null);
        }
        this.environment.pop(TrackableComponentEventCallback.class);
        this.environment.pop(ComponentEventResultProcessor.class);
        if (callback.isAborted()) {
            callback.rethrow();
            return;
        }
        if (!this.response.isCommitted()) {
            this.resultProcessor.processResultValue(activePage.getName());
        }
    }
}

