/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.javadoc.ClassDescription;
import org.apache.tapestry5.javadoc.ClassDescriptionSource;
import org.apache.tapestry5.javadoc.ParameterDescription;
import org.apache.tapestry5.javadoc.XDocStreamer;

public class TapestryDocTaglet
implements Taglet,
ClassDescriptionSource {
    private final Map<String, ClassDescription> classDescriptions = CollectionFactory.newMap();
    private ClassDoc firstSeen;
    private static final String NAME = "tapestrydoc";

    public static void register(Map paramMap) {
        paramMap.put(NAME, new TapestryDocTaglet());
    }

    public boolean inField() {
        return false;
    }

    public boolean inConstructor() {
        return false;
    }

    public boolean inMethod() {
        return false;
    }

    public boolean inOverview() {
        return false;
    }

    public boolean inPackage() {
        return false;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return false;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public ClassDescription getDescription(String className) {
        ClassDescription result = this.classDescriptions.get(className);
        if (result == null) {
            ClassDoc cd = this.firstSeen.findClass(className);
            result = cd == null ? new ClassDescription() : new ClassDescription(cd, this);
            this.classDescriptions.put(className, result);
        }
        return result;
    }

    public String toString(Tag tag) {
        throw new IllegalStateException("toString(Tag) should not be called for a non-inline tag.");
    }

    public String toString(Tag[] tags) {
        if (tags.length == 0) {
            return null;
        }
        Tag tag = tags[0];
        try {
            StringWriter writer = new StringWriter(5000);
            ClassDoc classDoc = (ClassDoc)tag.holder();
            if (this.firstSeen == null) {
                this.firstSeen = classDoc;
            }
            ClassDescription cd = this.getDescription(classDoc.qualifiedName());
            this.writeClassDescription(cd, writer);
            this.streamXdoc(classDoc, writer);
            return writer.toString();
        }
        catch (Exception ex) {
            System.err.println(ex);
            System.exit(-1);
            return null;
        }
    }

    private void writeElement(Writer writer, String elementSpec, String text) throws IOException {
        String elementName = elementSpec;
        int idxOfSpace = elementSpec.indexOf(32);
        if (idxOfSpace != -1) {
            elementName = elementSpec.substring(0, idxOfSpace);
        }
        writer.write(String.format("<%s>%s</%s>", elementSpec, InternalUtils.isBlank((String)text) ? "&nbsp;" : text, elementName));
    }

    private void writeClassDescription(ClassDescription cd, Writer writer) throws IOException {
        this.writeParameters(cd, writer);
        this.writeEvents(cd, writer);
    }

    private void writeParameters(ClassDescription cd, Writer writer) throws IOException {
        if (cd.parameters.isEmpty()) {
            return;
        }
        writer.write("</dl><table class='parameters'><caption><span>Component Parameters</span><span class='tabEnd'>&nbsp;</span></caption><tr class='columnHeaders'><th class='colFirst'>Name</th><th>Type</th><th>Flags</th><th>Default</th><th class='colLast'>Default Prefix</th></tr><tbody>");
        int toggle = 0;
        for (String name : InternalUtils.sortedKeys(cd.parameters)) {
            ParameterDescription pd = cd.parameters.get(name);
            this.writerParameter(pd, this.alternateCssClass(toggle++), writer);
        }
        writer.write("</tbody></table></dd>");
    }

    private void writerParameter(ParameterDescription pd, String rowClass, Writer writer) throws IOException {
        writer.write("<tr class='values " + rowClass + "'>");
        writer.write("<td rowspan='2' class='colFirst'>");
        writer.write(pd.name);
        writer.write("</td>");
        this.writeElement(writer, "td", this.addWordBreaks(this.shortenClassName(pd.type)));
        List flags = CollectionFactory.newList();
        if (pd.required) {
            flags.add("Required");
        }
        if (!pd.cache) {
            flags.add("Not Cached");
        }
        if (!pd.allowNull) {
            flags.add("Not Null");
        }
        if (InternalUtils.isNonBlank((String)pd.since)) {
            flags.add("Since " + pd.since);
        }
        this.writeElement(writer, "td", InternalUtils.join((List)flags));
        this.writeElement(writer, "td", this.addWordBreaks(pd.defaultValue));
        this.writeElement(writer, "td class='colLast'", pd.defaultPrefix);
        writer.write("</tr>");
        String description = pd.extractDescription();
        if (description.length() > 0) {
            writer.write("<tr class='" + rowClass + "'>");
            writer.write("<td colspan='4' class='description colLast'>");
            writer.write(description);
            writer.write("</td>");
            writer.write("</tr>");
        }
    }

    private String alternateCssClass(int num) {
        return num % 2 == 0 ? "altColor" : "rowColor";
    }

    private void writeEvents(ClassDescription cd, Writer writer) throws IOException {
        if (cd.events.isEmpty()) {
            return;
        }
        writer.write("<p><table class='parameters'><caption><span>Component Events</span><span class='tabEnd'>&nbsp;</span></caption><tr class='columnHeaders'><th class='colFirst'>Name</th><th class='colLast'>Description</th></tr><tbody>");
        int toggle = 0;
        for (String name : InternalUtils.sortedKeys(cd.events)) {
            writer.write("<tr class='" + this.alternateCssClass(toggle++) + "'>");
            this.writeElement(writer, "td class='colFirst'", name);
            String value = cd.events.get(name);
            this.writeElement(writer, "td class='colLast'", value);
            writer.write("</tr>");
        }
        writer.write("</table></p>");
    }

    private String addWordBreaks(String words) {
        return words.replace(".", ".<wbr/>").replace(":", ":<wbr/>");
    }

    private String shortenClassName(String name) {
        return name.replace("java.lang.", "");
    }

    private void streamXdoc(ClassDoc classDoc, Writer writer) throws Exception {
        File sourceFile = classDoc.position().file();
        String sourceName = sourceFile.getName();
        String xdocName = sourceName.replaceAll("\\.java$", ".xdoc");
        File xdocFile = new File(sourceFile.getParentFile(), xdocName);
        if (xdocFile.exists()) {
            try {
                new XDocStreamer(xdocFile, writer).writeContent();
            }
            catch (Exception ex) {
                System.err.println("Error streaming XDOC content for " + classDoc);
                throw ex;
            }
        }
    }
}

