/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.internal.plastic.AbstractMethodInvocation;
import org.apache.tapestry5.internal.plastic.ClassInstantiatorImpl;
import org.apache.tapestry5.internal.plastic.DelegatingAnnotationAccess;
import org.apache.tapestry5.internal.plastic.FieldInstrumentation;
import org.apache.tapestry5.internal.plastic.FieldInstrumentations;
import org.apache.tapestry5.internal.plastic.InheritanceData;
import org.apache.tapestry5.internal.plastic.InstructionBuilderImpl;
import org.apache.tapestry5.internal.plastic.InternalPlasticClassTransformation;
import org.apache.tapestry5.internal.plastic.Lockable;
import org.apache.tapestry5.internal.plastic.NameCache;
import org.apache.tapestry5.internal.plastic.PlasticClassHandleShim;
import org.apache.tapestry5.internal.plastic.PlasticClassPool;
import org.apache.tapestry5.internal.plastic.PlasticFieldImpl;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.PlasticMethodImpl;
import org.apache.tapestry5.internal.plastic.StaticContext;
import org.apache.tapestry5.internal.plastic.asm.AnnotationVisitor;
import org.apache.tapestry5.internal.plastic.asm.Opcodes;
import org.apache.tapestry5.internal.plastic.asm.Type;
import org.apache.tapestry5.internal.plastic.asm.tree.AbstractInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.AnnotationNode;
import org.apache.tapestry5.internal.plastic.asm.tree.ClassNode;
import org.apache.tapestry5.internal.plastic.asm.tree.FieldInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.FieldNode;
import org.apache.tapestry5.internal.plastic.asm.tree.InsnList;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodNode;
import org.apache.tapestry5.internal.plastic.asm.tree.VarInsnNode;
import org.apache.tapestry5.plastic.AnnotationAccess;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.ClassType;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.ConstructorCallback;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodInvocationResult;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.SwitchBlock;
import org.apache.tapestry5.plastic.SwitchCallback;

public class PlasticClassImpl
extends Lockable
implements PlasticClass,
InternalPlasticClassTransformation,
Opcodes {
    private static final String NOTHING_TO_VOID = "()V";
    static final String CONSTRUCTOR_NAME = "<init>";
    private static final String OBJECT_INT_TO_OBJECT = "(Ljava/lang/Object;I)Ljava/lang/Object;";
    private static final String OBJECT_INT_OBJECT_TO_VOID = "(Ljava/lang/Object;ILjava/lang/Object;)V";
    private static final String OBJECT_INT_OBJECT_ARRAY_TO_METHOD_INVOCATION_RESULT = String.format("(Ljava/lang/Object;I[Ljava/lang/Object;)%s", PlasticClassImpl.toDesc(Type.getInternalName(MethodInvocationResult.class)));
    static final String ABSTRACT_METHOD_INVOCATION_INTERNAL_NAME = PlasticInternalUtils.toInternalName(AbstractMethodInvocation.class.getName());
    private static final String HANDLE_SHIM_BASE_CLASS_INTERNAL_NAME = Type.getInternalName(PlasticClassHandleShim.class);
    static final String STATIC_CONTEXT_INTERNAL_NAME = Type.getInternalName(StaticContext.class);
    private static final String INSTANCE_CONTEXT_INTERNAL_NAME = Type.getInternalName(InstanceContext.class);
    private static final String INSTANCE_CONTEXT_DESC = PlasticClassImpl.toDesc(INSTANCE_CONTEXT_INTERNAL_NAME);
    private static final String CONSTRUCTOR_DESC = String.format("(L%s;L%s;)V", STATIC_CONTEXT_INTERNAL_NAME, INSTANCE_CONTEXT_INTERNAL_NAME);
    static final Method STATIC_CONTEXT_GET_METHOD = PlasticClassImpl.toMethod(StaticContext.class, "get", Integer.TYPE);
    static final Method COMPUTED_VALUE_GET_METHOD = PlasticClassImpl.toMethod(ComputedValue.class, "get", InstanceContext.class);
    private static final Method CONSTRUCTOR_CALLBACK_METHOD = PlasticClassImpl.toMethod(ConstructorCallback.class, "onConstruct", Object.class, InstanceContext.class);
    final ClassNode classNode;
    final PlasticClassPool pool;
    private final boolean proxy;
    final String className;
    private final String superClassName;
    private final AnnotationAccess annotationAccess;
    private final List<PlasticMethodImpl> methods;
    private final Map<MethodDescription, PlasticMethod> description2method = new HashMap<MethodDescription, PlasticMethod>();
    final Set<String> methodNames = new HashSet<String>();
    private final List<ConstructorCallback> constructorCallbacks = PlasticInternalUtils.newList();
    private final List<PlasticFieldImpl> fields;
    final Set<PlasticMethodImpl> advisedMethods = PlasticInternalUtils.newSet();
    final NameCache nameCache = new NameCache();
    List<PlasticField> unclaimedFields;
    private final Set<String> fieldNames = PlasticInternalUtils.newSet();
    final StaticContext staticContext;
    final InheritanceData parentInheritanceData;
    final InheritanceData inheritanceData;
    final Set<MethodNode> fieldTransformMethods = PlasticInternalUtils.newSet();
    final Set<MethodNode> shimInvokedMethods = PlasticInternalUtils.newSet();
    private final FieldInstrumentations fieldInstrumentations;
    private MethodNode originalConstructor;
    private final MethodNode newConstructor;
    final InstructionBuilder constructorBuilder;
    private String instanceContextFieldName;
    private Class<?> transformedClass;
    int nextFieldIndex = 0;
    int nextMethodIndex = 0;
    final Set<PlasticFieldImpl> shimFields = PlasticInternalUtils.newSet();
    final Set<PlasticMethodImpl> shimMethods = PlasticInternalUtils.newSet();
    final ClassNode implementationClassNode;
    private ClassNode interfaceClassNode;

    private static String toDesc(String internalName) {
        return "L" + internalName + ";";
    }

    private static Method toMethod(Class declaringClass, String methodName, Class ... parameterTypes) {
        return PlasticUtils.getMethod(declaringClass, methodName, parameterTypes);
    }

    static <T> T safeArrayDeref(T[] array, int index) {
        if (array == null) {
            return null;
        }
        return array[index];
    }

    public PlasticClassImpl(ClassNode classNode, ClassNode implementationClassNode, PlasticClassPool pool, InheritanceData parentInheritanceData, StaticContext parentStaticContext, boolean proxy) {
        this.classNode = classNode;
        this.pool = pool;
        this.proxy = proxy;
        this.implementationClassNode = implementationClassNode;
        this.staticContext = parentStaticContext.dupe();
        this.className = PlasticInternalUtils.toClassName(classNode.name);
        this.superClassName = PlasticInternalUtils.toClassName(classNode.superName);
        int lastIndexOfDot = this.className.lastIndexOf(46);
        String packageName = lastIndexOfDot > -1 ? this.className.substring(0, lastIndexOfDot) : "";
        this.fieldInstrumentations = new FieldInstrumentations(classNode.superName);
        this.annotationAccess = new DelegatingAnnotationAccess(pool.createAnnotationAccess(classNode.visibleAnnotations), pool.createAnnotationAccess(this.superClassName));
        this.parentInheritanceData = parentInheritanceData;
        this.inheritanceData = parentInheritanceData.createChild(packageName);
        for (String interfaceName : classNode.interfaces) {
            this.inheritanceData.addInterface(interfaceName);
        }
        this.methods = new ArrayList<PlasticMethodImpl>(classNode.methods.size());
        String invalidConstructorMessage = this.invalidConstructorMessage();
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode.name.equals(CONSTRUCTOR_NAME)) {
                if (methodNode.desc.equals(NOTHING_TO_VOID)) {
                    this.originalConstructor = methodNode;
                    this.fieldTransformMethods.add(methodNode);
                    continue;
                }
                methodNode.instructions.clear();
                this.newBuilder(methodNode).throwException(IllegalStateException.class, invalidConstructorMessage);
                continue;
            }
            if (Modifier.isStatic(methodNode.access)) {
                if (this.isInheritableMethod(methodNode)) {
                    this.inheritanceData.addMethod(methodNode.name, methodNode.desc, methodNode.access == 0);
                }
                this.methodNames.add(methodNode.name);
                this.fieldTransformMethods.add(methodNode);
                continue;
            }
            if (!Modifier.isAbstract(methodNode.access)) {
                this.fieldTransformMethods.add(methodNode);
            }
            PlasticMethodImpl pmi = new PlasticMethodImpl(this, methodNode);
            this.methods.add(pmi);
            this.description2method.put(pmi.getDescription(), pmi);
            if (this.isInheritableMethod(methodNode)) {
                this.inheritanceData.addMethod(methodNode.name, methodNode.desc, methodNode.access == 0);
            }
            this.methodNames.add(methodNode.name);
        }
        this.methodNames.addAll(parentInheritanceData.methodNames());
        Collections.sort(this.methods);
        this.fields = new ArrayList<PlasticFieldImpl>(classNode.fields.size());
        for (FieldNode fieldNode : classNode.fields) {
            this.fieldNames.add(fieldNode.name);
            if (Modifier.isStatic(fieldNode.access)) continue;
            this.fields.add(new PlasticFieldImpl(this, fieldNode));
        }
        Collections.sort(this.fields);
        this.newConstructor = new MethodNode(1, CONSTRUCTOR_NAME, CONSTRUCTOR_DESC, null, null);
        this.constructorBuilder = this.newBuilder(this.newConstructor);
        if (parentInheritanceData.isTransformed()) {
            this.constructorBuilder.loadThis().loadArgument(0).loadArgument(1);
            this.constructorBuilder.invokeConstructor(this.superClassName, StaticContext.class.getName(), InstanceContext.class.getName());
        } else {
            this.constructorBuilder.loadThis().invokeConstructor(this.superClassName, new String[0]);
        }
    }

    private String invalidConstructorMessage() {
        return String.format("Class %s has been transformed and may not be directly instantiated.", this.className);
    }

    @Override
    public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
        this.check();
        return this.annotationAccess.hasAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        this.check();
        return this.annotationAccess.getAnnotation(annotationType);
    }

    private static void addMethodAndParameterAnnotationsFromExistingClass(MethodNode methodNode, MethodNode implementationMethodNode) {
        AnnotationNode an;
        int j;
        List<AnnotationNode> l;
        AnnotationNode an2;
        int i;
        if (implementationMethodNode.annotationDefault != null) {
            AnnotationVisitor av = methodNode.visitAnnotationDefault();
            AnnotationNode.accept(av, null, implementationMethodNode.annotationDefault);
            if (av != null) {
                av.visitEnd();
            }
        }
        int n = implementationMethodNode.visibleAnnotations == null ? 0 : implementationMethodNode.visibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = implementationMethodNode.visibleAnnotations.get(i);
            an2.accept(methodNode.visitAnnotation(an2.desc, true));
        }
        n = implementationMethodNode.invisibleAnnotations == null ? 0 : implementationMethodNode.invisibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = implementationMethodNode.invisibleAnnotations.get(i);
            an2.accept(methodNode.visitAnnotation(an2.desc, false));
        }
        n = implementationMethodNode.visibleParameterAnnotations == null ? 0 : implementationMethodNode.visibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = implementationMethodNode.visibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = l.get(j);
                an.accept(methodNode.visitParameterAnnotation(i, an.desc, true));
            }
        }
        n = implementationMethodNode.invisibleParameterAnnotations == null ? 0 : implementationMethodNode.invisibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = implementationMethodNode.invisibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = l.get(j);
                an.accept(methodNode.visitParameterAnnotation(i, an.desc, false));
            }
        }
        methodNode.visitEnd();
    }

    private static void removeDuplicatedAnnotations(MethodNode node) {
        PlasticClassImpl.removeDuplicatedAnnotations(node.visibleAnnotations);
        PlasticClassImpl.removeDuplicatedAnnotations(node.invisibleAnnotations);
        if (node.visibleParameterAnnotations != null) {
            for (List<AnnotationNode> list : node.visibleParameterAnnotations) {
                PlasticClassImpl.removeDuplicatedAnnotations(list);
            }
        }
        if (node.invisibleParameterAnnotations != null) {
            for (List<AnnotationNode> list : node.invisibleParameterAnnotations) {
                PlasticClassImpl.removeDuplicatedAnnotations(list);
            }
        }
    }

    private static void removeDuplicatedAnnotations(ClassNode node) {
        PlasticClassImpl.removeDuplicatedAnnotations(node.visibleAnnotations, true);
        PlasticClassImpl.removeDuplicatedAnnotations(node.invisibleAnnotations, true);
    }

    private static void removeDuplicatedAnnotations(List<AnnotationNode> list) {
        PlasticClassImpl.removeDuplicatedAnnotations(list, false);
    }

    private static void removeDuplicatedAnnotations(List<AnnotationNode> list, boolean reverse) {
        if (list != null) {
            List<AnnotationNode> toBeIterated;
            HashSet<String> annotations = new HashSet<String>();
            ArrayList<AnnotationNode> toBeRemoved = new ArrayList<AnnotationNode>();
            if (reverse) {
                toBeIterated = new ArrayList<AnnotationNode>(list);
                Collections.reverse(toBeIterated);
            } else {
                toBeIterated = list;
            }
            for (AnnotationNode annotationNode : toBeIterated) {
                if (annotations.contains(annotationNode.desc)) {
                    toBeRemoved.add(annotationNode);
                    continue;
                }
                annotations.add(annotationNode.desc);
            }
            for (AnnotationNode annotationNode : toBeRemoved) {
                list.remove(annotationNode);
            }
        }
    }

    private static String getParametersDesc(MethodNode methodNode) {
        return methodNode.desc.substring(methodNode.desc.indexOf(40) + 1, methodNode.desc.lastIndexOf(41));
    }

    private static MethodNode findExactMatchMethod(MethodNode methodNode, ClassNode source) {
        MethodNode found = null;
        String methodDescription = PlasticClassImpl.getParametersDesc(methodNode);
        for (MethodNode implementationMethodNode : source.methods) {
            String implementationMethodDescription = PlasticClassImpl.getParametersDesc(implementationMethodNode);
            if (!methodNode.name.equals(implementationMethodNode.name) || (implementationMethodNode.access & 0x1000) != 0 || !methodDescription.equals(implementationMethodDescription)) continue;
            found = implementationMethodNode;
            break;
        }
        return found;
    }

    private static List<Class> getJavaParameterTypes(MethodNode methodNode) {
        ClassLoader classLoader = PlasticInternalUtils.class.getClassLoader();
        Type[] parameterTypes = Type.getArgumentTypes(methodNode.desc);
        ArrayList<Class> list = new ArrayList<Class>();
        for (Type type : parameterTypes) {
            try {
                list.add(PlasticInternalUtils.toClass(classLoader, type.getClassName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    private static MethodNode findGenericMethod(MethodNode methodNode, ClassNode classNode) {
        MethodNode found = null;
        List<Class> parameterTypes = PlasticClassImpl.getJavaParameterTypes(methodNode);
        for (MethodNode implementationMethodNode : classNode.methods) {
            if (!methodNode.name.equals(implementationMethodNode.name)) continue;
            List<Class> implementationParameterTypes = PlasticClassImpl.getJavaParameterTypes(implementationMethodNode);
            if (parameterTypes.size() != implementationParameterTypes.size()) continue;
            boolean matches = true;
            for (int i = 0; i < parameterTypes.size(); ++i) {
                Class implementationParameterType = implementationParameterTypes.get(i);
                Class parameterType = parameterTypes.get(i);
                if (parameterType.isAssignableFrom(implementationParameterType)) continue;
                matches = false;
                break;
            }
            if (!matches || PlasticClassImpl.isBridge(implementationMethodNode)) continue;
            found = implementationMethodNode;
            break;
        }
        return found;
    }

    private static void addMethodAndParameterAnnotationsFromExistingClass(MethodNode methodNode, ClassNode source) {
        if (source != null) {
            MethodNode candidate = PlasticClassImpl.findExactMatchMethod(methodNode, source);
            String parametersDesc = PlasticClassImpl.getParametersDesc(methodNode);
            if (candidate == null && parametersDesc.trim().length() > 0) {
                candidate = PlasticClassImpl.findGenericMethod(methodNode, source);
            }
            if (candidate != null) {
                PlasticClassImpl.addMethodAndParameterAnnotationsFromExistingClass(methodNode, candidate);
            }
        }
    }

    private static boolean isBridge(MethodNode methodNode) {
        return Modifier.isVolatile(methodNode.access);
    }

    @Override
    public PlasticClass proxyInterface(Class interfaceType, PlasticField field) {
        this.check();
        assert (field != null);
        this.introduceInterface(interfaceType);
        Map<MethodSignature, MethodDescription> map = this.createMethodSignatureMap(interfaceType);
        for (MethodSignature methodSignature : map.keySet()) {
            this.introduceMethod(map.get(methodSignature)).delegateTo(field);
        }
        return this;
    }

    @Override
    public PlasticClass proxyInterface(Class interfaceType, PlasticMethod method) {
        this.check();
        assert (method != null);
        this.introduceInterface(interfaceType);
        Map<MethodSignature, MethodDescription> map = this.createMethodSignatureMap(interfaceType);
        for (MethodSignature methodSignature : map.keySet()) {
            this.introduceMethod(map.get(methodSignature)).delegateTo(method);
        }
        return this;
    }

    public ClassInstantiator createInstantiator() {
        this.lock();
        this.addClassAnnotations(this.implementationClassNode);
        PlasticClassImpl.removeDuplicatedAnnotations(this.classNode);
        this.createShimIfNeeded();
        this.interceptFieldAccess();
        this.rewriteAdvisedMethods();
        this.completeConstructor();
        this.transformedClass = this.pool.realizeTransformedClass(this.classNode, this.inheritanceData, this.staticContext);
        return this.createInstantiatorFromClass(this.transformedClass);
    }

    private void addClassAnnotations(ClassNode otherClassNode) {
        if (otherClassNode != null) {
            AnnotationNode an;
            int i;
            int n = otherClassNode.visibleAnnotations == null ? 0 : otherClassNode.visibleAnnotations.size();
            for (i = 0; i < n; ++i) {
                an = otherClassNode.visibleAnnotations.get(i);
                an.accept(this.classNode.visitAnnotation(an.desc, true));
            }
            n = otherClassNode.invisibleAnnotations == null ? 0 : otherClassNode.invisibleAnnotations.size();
            for (i = 0; i < n; ++i) {
                an = otherClassNode.invisibleAnnotations.get(i);
                an.accept(this.classNode.visitAnnotation(an.desc, false));
            }
        }
    }

    private ClassInstantiator createInstantiatorFromClass(Class clazz) {
        try {
            Constructor ctor = clazz.getConstructor(StaticContext.class, InstanceContext.class);
            return new ClassInstantiatorImpl(clazz, ctor, this.staticContext);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to create ClassInstantiator for class %s: %s", clazz.getName(), PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    private void completeConstructor() {
        if (this.originalConstructor != null) {
            this.convertOriginalConstructorToMethod();
        }
        this.invokeCallbacks();
        this.constructorBuilder.returnResult();
        this.classNode.methods.add(this.newConstructor);
    }

    private void invokeCallbacks() {
        for (ConstructorCallback callback : this.constructorCallbacks) {
            this.invokeCallback(callback);
        }
    }

    private void invokeCallback(ConstructorCallback callback) {
        int index = this.staticContext.store(callback);
        this.constructorBuilder.loadArgument(0).loadConstant(index).invoke(STATIC_CONTEXT_GET_METHOD).castOrUnbox(ConstructorCallback.class.getName());
        this.constructorBuilder.loadThis().loadArgument(1);
        this.constructorBuilder.invoke(CONSTRUCTOR_CALLBACK_METHOD);
    }

    private void convertOriginalConstructorToMethod() {
        String initializerName = this.makeUnique(this.methodNames, "initializeInstance");
        int originalAccess = this.originalConstructor.access;
        this.originalConstructor.access = 2;
        this.originalConstructor.name = initializerName;
        this.stripOutSuperConstructorCall(this.originalConstructor);
        this.constructorBuilder.loadThis().invokeVirtual(this.className, "void", initializerName, new String[0]);
        MethodNode replacementConstructor = new MethodNode(originalAccess, CONSTRUCTOR_NAME, NOTHING_TO_VOID, null, null);
        this.newBuilder(replacementConstructor).throwException(IllegalStateException.class, this.invalidConstructorMessage());
        this.classNode.methods.add(replacementConstructor);
    }

    private void stripOutSuperConstructorCall(MethodNode cons) {
        AbstractInsnNode node;
        InsnList ins = cons.instructions;
        ListIterator<AbstractInsnNode> li = ins.iterator();
        while (li.hasNext()) {
            node = li.next();
            if (node.getOpcode() != 25) continue;
            VarInsnNode varNode = (VarInsnNode)node;
            assert (varNode.var == 0);
            li.remove();
            break;
        }
        while (li.hasNext()) {
            node = li.next();
            if (node.getOpcode() != 183) continue;
            MethodInsnNode mnode = (MethodInsnNode)node;
            assert (mnode.owner.equals(this.classNode.superName));
            assert (mnode.name.equals(CONSTRUCTOR_NAME));
            assert (mnode.desc.equals(cons.desc));
            li.remove();
            return;
        }
        throw new AssertionError((Object)"Could not convert constructor to simple method.");
    }

    @Override
    public <T extends Annotation> List<PlasticField> getFieldsWithAnnotation(Class<T> annotationType) {
        this.check();
        List<PlasticField> result = this.getAllFields();
        Iterator<PlasticField> iterator = result.iterator();
        while (iterator.hasNext()) {
            PlasticField plasticField = iterator.next();
            if (plasticField.hasAnnotation(annotationType)) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public List<PlasticField> getAllFields() {
        this.check();
        return new ArrayList<PlasticField>(this.fields);
    }

    @Override
    public List<PlasticField> getUnclaimedFields() {
        this.check();
        if (this.unclaimedFields == null) {
            this.unclaimedFields = new ArrayList<PlasticField>(this.fields.size());
            for (PlasticField plasticField : this.fields) {
                if (plasticField.isClaimed()) continue;
                this.unclaimedFields.add(plasticField);
            }
        }
        return this.unclaimedFields;
    }

    @Override
    public PlasticMethod introducePrivateMethod(String typeName, String suggestedName, String[] argumentTypes, String[] exceptionTypes) {
        this.check();
        assert (PlasticInternalUtils.isNonBlank(typeName));
        assert (PlasticInternalUtils.isNonBlank(suggestedName));
        String name = this.makeUnique(this.methodNames, suggestedName);
        MethodDescription description = new MethodDescription(2, typeName, name, argumentTypes, null, exceptionTypes);
        return this.introduceMethod(description);
    }

    @Override
    public PlasticField introduceField(String className, String suggestedName) {
        this.check();
        assert (PlasticInternalUtils.isNonBlank(className));
        assert (PlasticInternalUtils.isNonBlank(suggestedName));
        String name = this.makeUnique(this.fieldNames, suggestedName);
        FieldNode fieldNode = new FieldNode(2, name, PlasticInternalUtils.toDescriptor(className), null, null);
        this.classNode.fields.add(fieldNode);
        this.fieldNames.add(name);
        PlasticFieldImpl newField = new PlasticFieldImpl(this, fieldNode);
        return newField;
    }

    @Override
    public PlasticField introduceField(Class fieldType, String suggestedName) {
        assert (fieldType != null);
        return this.introduceField(this.nameCache.toTypeName(fieldType), suggestedName);
    }

    String makeUnique(Set<String> values, String input) {
        return values.contains(input) ? input + "$" + PlasticUtils.nextUID() : input;
    }

    @Override
    public <T extends Annotation> List<PlasticMethod> getMethodsWithAnnotation(Class<T> annotationType) {
        this.check();
        List<PlasticMethod> result = this.getMethods();
        Iterator<PlasticMethod> iterator = result.iterator();
        while (iterator.hasNext()) {
            PlasticMethod method = iterator.next();
            if (method.hasAnnotation(annotationType)) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public List<PlasticMethod> getMethods() {
        this.check();
        return new ArrayList<PlasticMethod>(this.methods);
    }

    @Override
    public PlasticMethod introduceMethod(MethodDescription description) {
        PlasticMethod result;
        this.check();
        if (Modifier.isAbstract(description.modifiers)) {
            description = description.withModifiers(description.modifiers & 0xFFFFFBFF);
        }
        if ((result = this.description2method.get(description)) == null) {
            result = this.createNewMethod(description);
            this.description2method.put(description, result);
        }
        this.methodNames.add(description.methodName);
        return result;
    }

    @Override
    public PlasticMethod introduceMethod(MethodDescription description, InstructionBuilderCallback callback) {
        this.check();
        return this.introduceMethod(description).changeImplementation(callback);
    }

    @Override
    public PlasticMethod introduceMethod(Method method) {
        this.check();
        return this.introduceMethod(new MethodDescription(method));
    }

    void addMethod(MethodNode methodNode) {
        this.classNode.methods.add(methodNode);
        this.methodNames.add(methodNode.name);
        if (this.isInheritableMethod(methodNode)) {
            this.inheritanceData.addMethod(methodNode.name, methodNode.desc, methodNode.access == 0);
        }
    }

    private PlasticMethod createNewMethod(MethodDescription description) {
        if (Modifier.isStatic(description.modifiers)) {
            throw new IllegalArgumentException(String.format("Unable to introduce method '%s' into class %s: introduced methods may not be static.", description, this.className));
        }
        String desc = this.nameCache.toDesc(description);
        String[] exceptions = new String[description.checkedExceptionTypes.length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = PlasticInternalUtils.toInternalName(description.checkedExceptionTypes[i]);
        }
        MethodNode methodNode = new MethodNode(description.modifiers, description.methodName, desc, description.genericSignature, exceptions);
        boolean isOverride = this.inheritanceData.isImplemented(methodNode.name, desc);
        if (!isOverride) {
            PlasticClassImpl.addMethodAndParameterAnnotationsFromExistingClass(methodNode, this.implementationClassNode);
            PlasticClassImpl.addMethodAndParameterAnnotationsFromExistingClass(methodNode, this.interfaceClassNode);
            PlasticClassImpl.removeDuplicatedAnnotations(methodNode);
        }
        if (isOverride) {
            this.createOverrideOfBaseClassImpl(description, methodNode);
        } else {
            this.createNewMethodImpl(description, methodNode);
        }
        this.addMethod(methodNode);
        return new PlasticMethodImpl(this, methodNode);
    }

    private boolean isDefaultMethod(Method method) {
        return method.getDeclaringClass().isInterface() && (method.getModifiers() & 0x409) == 1;
    }

    private void createNewMethodImpl(MethodDescription methodDescription, MethodNode methodNode) {
        this.newBuilder(methodDescription, methodNode).returnDefaultValue();
    }

    private void createOverrideOfBaseClassImpl(MethodDescription methodDescription, MethodNode methodNode) {
        InstructionBuilderImpl builder = this.newBuilder(methodDescription, methodNode);
        builder.loadThis();
        builder.loadArguments();
        builder.invokeSpecial(this.superClassName, methodDescription);
        builder.returnResult();
    }

    private void interceptFieldAccess() {
        for (MethodNode node : this.fieldTransformMethods) {
            this.interceptFieldAccess(node);
        }
    }

    private void createShimIfNeeded() {
        if (this.shimFields.isEmpty() && this.shimMethods.isEmpty()) {
            return;
        }
        PlasticClassHandleShim shim = this.createShimInstance();
        this.installShim(shim);
    }

    public void installShim(PlasticClassHandleShim shim) {
        for (PlasticFieldImpl f : this.shimFields) {
            f.installShim(shim);
        }
        for (PlasticMethodImpl m : this.shimMethods) {
            m.installShim(shim);
        }
    }

    public PlasticClassHandleShim createShimInstance() {
        String shimClassName = String.format("%s$Shim_%s", this.classNode.name, PlasticUtils.nextUID());
        ClassNode shimClassNode = new ClassNode();
        shimClassNode.visit(50, 17, shimClassName, null, HANDLE_SHIM_BASE_CLASS_INTERNAL_NAME, null);
        this.implementConstructor(shimClassNode);
        if (!this.shimFields.isEmpty()) {
            this.implementShimGet(shimClassNode);
            this.implementShimSet(shimClassNode);
        }
        if (!this.shimMethods.isEmpty()) {
            this.implementShimInvoke(shimClassNode);
        }
        return this.instantiateShim(shimClassNode);
    }

    private void implementConstructor(ClassNode shimClassNode) {
        MethodNode mn = new MethodNode(1, CONSTRUCTOR_NAME, NOTHING_TO_VOID, null, null);
        InstructionBuilderImpl builder = this.newBuilder(mn);
        builder.loadThis().invokeConstructor(PlasticClassHandleShim.class, new Class[0]).returnResult();
        shimClassNode.methods.add(mn);
    }

    private PlasticClassHandleShim instantiateShim(ClassNode shimClassNode) {
        try {
            Class shimClass = this.pool.realize(this.className, ClassType.SUPPORT, shimClassNode);
            return (PlasticClassHandleShim)shimClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to instantiate shim class %s for plastic class %s: %s", PlasticInternalUtils.toClassName(shimClassNode.name), this.className, PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    private void implementShimGet(ClassNode shimClassNode) {
        MethodNode mn = new MethodNode(1, "get", OBJECT_INT_TO_OBJECT, null, null);
        InstructionBuilderImpl builder = this.newBuilder(mn);
        builder.loadArgument(0).checkcast(this.className);
        builder.loadArgument(1);
        builder.startSwitch(0, this.nextFieldIndex - 1, new SwitchCallback(){

            @Override
            public void doSwitch(SwitchBlock block) {
                for (PlasticFieldImpl f : PlasticClassImpl.this.shimFields) {
                    f.extendShimGet(block);
                }
            }
        });
        shimClassNode.methods.add(mn);
    }

    private void implementShimSet(ClassNode shimClassNode) {
        MethodNode mn = new MethodNode(1, "set", OBJECT_INT_OBJECT_TO_VOID, null, null);
        InstructionBuilderImpl builder = this.newBuilder(mn);
        builder.loadArgument(0).checkcast(this.className);
        builder.loadArgument(2);
        builder.loadArgument(1);
        builder.startSwitch(0, this.nextFieldIndex - 1, new SwitchCallback(){

            @Override
            public void doSwitch(SwitchBlock block) {
                for (PlasticFieldImpl f : PlasticClassImpl.this.shimFields) {
                    f.extendShimSet(block);
                }
            }
        });
        builder.returnResult();
        shimClassNode.methods.add(mn);
    }

    private void implementShimInvoke(ClassNode shimClassNode) {
        MethodNode mn = new MethodNode(1, "invoke", OBJECT_INT_OBJECT_ARRAY_TO_METHOD_INVOCATION_RESULT, null, null);
        InstructionBuilderImpl builder = this.newBuilder(mn);
        builder.loadArgument(0).checkcast(this.className);
        builder.loadArgument(1);
        builder.startSwitch(0, this.nextMethodIndex - 1, new SwitchCallback(){

            @Override
            public void doSwitch(SwitchBlock block) {
                for (PlasticMethodImpl m : PlasticClassImpl.this.shimMethods) {
                    m.extendShimInvoke(block);
                }
            }
        });
        shimClassNode.methods.add(mn);
    }

    private void rewriteAdvisedMethods() {
        for (PlasticMethodImpl method : this.advisedMethods) {
            method.rewriteMethodForAdvice();
        }
    }

    private void interceptFieldAccess(MethodNode methodNode) {
        InsnList insns = methodNode.instructions;
        ListIterator<AbstractInsnNode> it = insns.iterator();
        while (it.hasNext()) {
            AbstractInsnNode node = it.next();
            int opcode = node.getOpcode();
            if (opcode != 180 && opcode != 181) continue;
            FieldInsnNode fnode = (FieldInsnNode)node;
            FieldInstrumentation instrumentation = this.findFieldNodeInstrumentation(fnode, opcode == 180);
            if (instrumentation == null) continue;
            insns.insertBefore((AbstractInsnNode)fnode, new MethodInsnNode(182, fnode.owner, instrumentation.methodName, instrumentation.methodDescription));
            it.remove();
        }
    }

    private FieldInstrumentation findFieldNodeInstrumentation(FieldInsnNode node, boolean forRead) {
        String searchStart = node.owner;
        if (searchStart.equals(this.classNode.name)) {
            FieldInstrumentation result = this.fieldInstrumentations.get(node.name, forRead);
            if (result != null) {
                return result;
            }
            searchStart = this.classNode.superName;
        }
        return this.pool.getFieldInstrumentation(searchStart, node.name, forRead);
    }

    String getInstanceContextFieldName() {
        if (this.instanceContextFieldName == null) {
            this.instanceContextFieldName = this.makeUnique(this.fieldNames, "instanceContext");
            FieldNode node = new FieldNode(18, this.instanceContextFieldName, INSTANCE_CONTEXT_DESC, null, null);
            this.classNode.fields.add(node);
            this.constructorBuilder.loadThis().loadArgument(1).putField(this.className, this.instanceContextFieldName, InstanceContext.class);
        }
        return this.instanceContextFieldName;
    }

    String createAndInitializeFieldFromStaticContext(String suggestedFieldName, String fieldType, Object injectedFieldValue) {
        String name = this.makeUnique(this.fieldNames, suggestedFieldName);
        FieldNode field = new FieldNode(18, name, this.nameCache.toDesc(fieldType), null, null);
        this.classNode.fields.add(field);
        this.initializeFieldFromStaticContext(name, fieldType, injectedFieldValue);
        return name;
    }

    void initializeFieldFromStaticContext(String fieldName, String fieldType, Object injectedFieldValue) {
        int index = this.staticContext.store(injectedFieldValue);
        this.constructorBuilder.loadThis();
        this.constructorBuilder.loadArgument(0).loadConstant(index);
        this.constructorBuilder.invoke(STATIC_CONTEXT_GET_METHOD);
        this.constructorBuilder.castOrUnbox(fieldType);
        this.constructorBuilder.putField(this.className, fieldName, fieldType);
    }

    void pushInstanceContextFieldOntoStack(InstructionBuilder builder) {
        builder.loadThis().getField(this.className, this.getInstanceContextFieldName(), InstanceContext.class);
    }

    @Override
    public PlasticClass getPlasticClass() {
        return this;
    }

    @Override
    public Class<?> getTransformedClass() {
        if (this.transformedClass == null) {
            throw new IllegalStateException(String.format("Transformed class %s is not yet available because the transformation is not yet complete.", this.className));
        }
        return this.transformedClass;
    }

    private boolean isInheritableMethod(MethodNode node) {
        return !Modifier.isPrivate(node.access);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    InstructionBuilderImpl newBuilder(MethodNode mn) {
        return this.newBuilder(PlasticInternalUtils.toMethodDescription(mn), mn);
    }

    InstructionBuilderImpl newBuilder(MethodDescription description, MethodNode mn) {
        return new InstructionBuilderImpl(description, mn, this.nameCache);
    }

    @Override
    public Set<PlasticMethod> introduceInterface(Class interfaceType) {
        this.check();
        assert (interfaceType != null);
        if (!interfaceType.isInterface()) {
            throw new IllegalArgumentException(String.format("Class %s is not an interface; only interfaces may be introduced.", interfaceType.getName()));
        }
        String interfaceName = this.nameCache.toInternalName(interfaceType);
        try {
            this.interfaceClassNode = PlasticClassPool.readClassNode(interfaceType.getName(), this.getClass().getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.inheritanceData.isInterfaceImplemented(interfaceName)) {
            this.classNode.interfaces.add(interfaceName);
            this.inheritanceData.addInterface(interfaceName);
        }
        this.addClassAnnotations(this.interfaceClassNode);
        HashSet<PlasticMethod> introducedMethods = new HashSet<PlasticMethod>();
        Map<MethodSignature, MethodDescription> map = this.createMethodSignatureMap(interfaceType);
        for (MethodSignature methodSignature : map.keySet()) {
            MethodDescription description = map.get(methodSignature);
            if (this.isMethodImplemented(description) || this.isDefaultMethod(methodSignature.method)) continue;
            introducedMethods.add(this.introduceMethod(description));
        }
        this.interfaceClassNode = null;
        return introducedMethods;
    }

    private Map<MethodSignature, MethodDescription> createMethodSignatureMap(Class interfaceType) {
        HashMap<MethodSignature, MethodDescription> map = new HashMap<MethodSignature, MethodDescription>();
        for (Method m : interfaceType.getMethods()) {
            MethodSignature methodSignature = new MethodSignature(m);
            MethodDescription newMethodDescription = new MethodDescription(m);
            if (!map.containsKey(methodSignature)) {
                map.put(methodSignature, newMethodDescription);
                continue;
            }
            if (newMethodDescription.checkedExceptionTypes == null || newMethodDescription.checkedExceptionTypes.length <= 0) continue;
            MethodDescription methodDescription = (MethodDescription)map.get(methodSignature);
            HashSet<String> checkedExceptionTypes = new HashSet<String>();
            checkedExceptionTypes.addAll(Arrays.asList(methodDescription.checkedExceptionTypes));
            checkedExceptionTypes.addAll(Arrays.asList(newMethodDescription.checkedExceptionTypes));
            map.put(methodSignature, new MethodDescription(methodDescription, checkedExceptionTypes.toArray(new String[checkedExceptionTypes.size()])));
        }
        return map;
    }

    @Override
    public PlasticClass addToString(final String toStringValue) {
        this.check();
        if (!this.isMethodImplemented(PlasticUtils.TO_STRING_DESCRIPTION)) {
            this.introduceMethod(PlasticUtils.TO_STRING_DESCRIPTION, new InstructionBuilderCallback(){

                @Override
                public void doBuild(InstructionBuilder builder) {
                    builder.loadConstant(toStringValue).returnResult();
                }
            });
        }
        return this;
    }

    @Override
    public boolean isMethodImplemented(MethodDescription description) {
        return this.inheritanceData.isImplemented(description.methodName, this.nameCache.toDesc(description));
    }

    @Override
    public boolean isInterfaceImplemented(Class interfaceType) {
        assert (interfaceType != null);
        assert (interfaceType.isInterface());
        String interfaceName = this.nameCache.toInternalName(interfaceType);
        return this.inheritanceData.isInterfaceImplemented(interfaceName);
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public PlasticClass onConstruct(ConstructorCallback callback) {
        this.check();
        assert (callback != null);
        this.constructorCallbacks.add(callback);
        return this;
    }

    void redirectFieldWrite(String fieldName, boolean privateField, MethodNode method) {
        FieldInstrumentation fi = new FieldInstrumentation(method.name, method.desc);
        this.fieldInstrumentations.write.put(fieldName, fi);
        if (!this.proxy && !privateField) {
            this.pool.setFieldWriteInstrumentation(this.classNode.name, fieldName, fi);
        }
    }

    void redirectFieldRead(String fieldName, boolean privateField, MethodNode method) {
        FieldInstrumentation fi = new FieldInstrumentation(method.name, method.desc);
        this.fieldInstrumentations.read.put(fieldName, fi);
        if (!this.proxy && !privateField) {
            this.pool.setFieldReadInstrumentation(this.classNode.name, fieldName, fi);
        }
    }

    public String toString() {
        return String.format("PlasticClassImpl[%s]", this.className);
    }

    private static final class MethodSignature
    implements Comparable<MethodSignature> {
        private final Method method;
        private final String name;
        private final Class<?>[] parameterTypes;

        public MethodSignature(Method method) {
            this.method = method;
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodSignature other = (MethodSignature)obj;
            if (!Arrays.equals(this.parameterTypes, other.parameterTypes)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Override
        public int compareTo(MethodSignature o) {
            return this.method.getName().compareTo(o.method.getName());
        }
    }
}

