/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.internal.services.ComponentInstanceProcessor;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.Traditional;
import org.slf4j.Logger;

@Marker(value={Traditional.class, ComponentInstanceProcessor.class})
public class ComponentInstanceResultProcessor
implements ComponentEventResultProcessor<Component> {
    private final Logger logger;
    private final ComponentEventResultProcessor resultProcessor;

    public ComponentInstanceResultProcessor(Logger logger, @Traditional @Primary ComponentEventResultProcessor resultProcessor) {
        this.logger = logger;
        this.resultProcessor = resultProcessor;
    }

    @Override
    public void processResultValue(Component value) throws IOException {
        ComponentResources resources = value.getComponentResources();
        if (resources.getContainer() != null) {
            this.logger.warn(String.format("Component %s was returned from an event handler method, but is not a page component. The page containing the component will render the client response.", value.getComponentResources().getCompleteId()));
        }
        this.resultProcessor.processResultValue(resources.getPageName());
    }
}

