/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.services.assets.DelegatingSRS;
import org.apache.tapestry5.internal.services.assets.StreamableResourceImpl;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSURLRewriter
extends DelegatingSRS {
    private final Pattern urlPattern = Pattern.compile("url\\(\\s*(['\"]?)(.+?)([\\#\\?].*?)?\\1\\s*\\)");
    private final Pattern completeURLPattern = Pattern.compile("^[#/]|(\\p{Alpha}\\w*:)");
    private final OperationTracker tracker;
    private final AssetSource assetSource;
    private final AssetChecksumGenerator checksumGenerator;
    private final Logger logger = LoggerFactory.getLogger(CSSURLRewriter.class);
    private final boolean strictCssUrlRewriting;
    private final ContentType CSS_CONTENT_TYPE = new ContentType("text/css");

    public CSSURLRewriter(StreamableResourceSource delegate, OperationTracker tracker, AssetSource assetSource, AssetChecksumGenerator checksumGenerator, boolean strictCssUrlRewriting) {
        super(delegate);
        this.tracker = tracker;
        this.assetSource = assetSource;
        this.checksumGenerator = checksumGenerator;
        this.strictCssUrlRewriting = strictCssUrlRewriting;
    }

    @Override
    public StreamableResource getStreamableResource(Resource baseResource, StreamableResourceProcessing processing, ResourceDependencies dependencies) throws IOException {
        StreamableResource base = this.delegate.getStreamableResource(baseResource, processing, dependencies);
        if (base.getContentType().equals(this.CSS_CONTENT_TYPE)) {
            return this.filter(base, baseResource);
        }
        return base;
    }

    private StreamableResource filter(final StreamableResource base, final Resource baseResource) throws IOException {
        return (StreamableResource)this.tracker.perform("Rewriting relative URLs in " + baseResource, (IOOperation)new IOOperation<StreamableResource>(){

            public StreamableResource perform() throws IOException {
                String baseString = CSSURLRewriter.this.readAsString(base);
                String filtered = CSSURLRewriter.this.replaceURLs(baseString, baseResource);
                if (filtered == null) {
                    return base;
                }
                BytestreamCache cache = new BytestreamCache(filtered.getBytes("UTF-8"));
                return new StreamableResourceImpl(base.getDescription(), CSSURLRewriter.this.CSS_CONTENT_TYPE, CompressionStatus.COMPRESSABLE, base.getLastModified(), cache, CSSURLRewriter.this.checksumGenerator, base.getResponseCustomizer());
            }
        });
    }

    private String replaceURLs(String input, Resource baseResource) {
        boolean didReplace = false;
        StringBuffer output = new StringBuffer(input.length());
        Matcher matcher = this.urlPattern.matcher(input);
        while (matcher.find()) {
            Asset asset;
            boolean isAssetUrl;
            String url = matcher.group(2);
            Matcher completeURLMatcher = this.completeURLPattern.matcher(url);
            boolean matchFound = completeURLMatcher.find();
            boolean bl = isAssetUrl = matchFound && "asset:".equals(completeURLMatcher.group(1));
            if (matchFound && !isAssetUrl) {
                String queryParameters = matcher.group(3);
                if (queryParameters != null) {
                    url = url + queryParameters;
                }
                this.appendReplacement(matcher, output, url);
                continue;
            }
            if (isAssetUrl) {
                url = url.substring(6);
            }
            if ((asset = this.assetSource.getAsset(baseResource, url, null)) != null) {
                String assetURL = asset.toClientURL();
                String queryParameters = matcher.group(3);
                if (queryParameters != null) {
                    assetURL = assetURL + queryParameters;
                }
                this.appendReplacement(matcher, output, assetURL);
                didReplace = true;
                continue;
            }
            String message = String.format("URL %s, referenced in file %s, doesn't exist.", url, baseResource.toURL(), baseResource);
            if (this.strictCssUrlRewriting) {
                throw new RuntimeException(message);
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn(message);
        }
        if (!didReplace) {
            return null;
        }
        matcher.appendTail(output);
        return output.toString();
    }

    private void appendReplacement(Matcher matcher, StringBuffer output, String assetURL) {
        matcher.appendReplacement(output, String.format("url(\"%s\")", assetURL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readAsString(StreamableResource resource) throws IOException {
        StringBuffer result = new StringBuffer(resource.getSize());
        char[] buffer = new char[5000];
        InputStream is = resource.openStream();
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        try {
            int length;
            while ((length = reader.read(buffer)) >= 0) {
                result.append(buffer, 0, length);
            }
        }
        finally {
            reader.close();
            is.close();
        }
        return result.toString();
    }
}

