/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.internal.services.MarkupWriterImpl;
import org.apache.tapestry5.internal.services.RenderQueueImpl;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.services.PartialTemplateRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialTemplateRendererImpl
implements PartialTemplateRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartialTemplateRendererImpl.class);
    private final TypeCoercer typeCoercer;

    public PartialTemplateRendererImpl(TypeCoercer typeCoercer) {
        this.typeCoercer = typeCoercer;
    }

    @Override
    public Document renderAsDocument(Object object) {
        RenderCommand renderCommand = this.toRenderCommand(object);
        MarkupWriterImpl markupWriter = new MarkupWriterImpl();
        RenderQueueImpl renderQueue = new RenderQueueImpl(LOGGER);
        renderQueue.push(renderCommand);
        renderQueue.run(markupWriter);
        return markupWriter.getDocument();
    }

    @Override
    public String render(Object object) {
        return this.renderAsDocument(object).toString();
    }

    private RenderCommand toRenderCommand(Object object) {
        RenderCommand renderCommand = null;
        if (object instanceof RenderCommand) {
            renderCommand = (RenderCommand)object;
        } else {
            try {
                renderCommand = (RenderCommand)this.typeCoercer.coerce(object, RenderCommand.class);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("Couldn't find a coercion from %s to RenderCommand", object.getClass().getName()), e);
            }
        }
        return renderCommand;
    }
}

