/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.json.JSON;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONCollection;
import org.apache.tapestry5.json.JSONLiteral;
import org.apache.tapestry5.json.JSONPrintSession;
import org.apache.tapestry5.json.JSONString;
import org.apache.tapestry5.json.JSONStringer;
import org.apache.tapestry5.json.JSONTokener;

public final class JSONObject
extends JSONCollection {
    private static final Double NEGATIVE_ZERO = -0.0;
    public static final Object NULL = new Serializable(){
        private static final long serialVersionUID = 1L;

        public boolean equals(Object o) {
            return o == this || o == null;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "null";
        }

        private Object readResolve() throws ObjectStreamException {
            return NULL;
        }
    };
    private final LinkedHashMap<String, Object> nameValuePairs;

    public JSONObject() {
        this.nameValuePairs = new LinkedHashMap();
    }

    JSONObject(JSONTokener readFrom) {
        Object object = readFrom.nextValue(JSONObject.class);
        if (!(object instanceof JSONObject)) {
            throw JSON.typeMismatch(object, "JSONObject");
        }
        this.nameValuePairs = ((JSONObject)object).nameValuePairs;
    }

    public JSONObject(String json) {
        this(new JSONTokener(json));
    }

    public JSONObject(JSONObject copyFrom, String[] names) {
        this();
        for (String name : names) {
            Object value = copyFrom.opt(name);
            if (value == null) continue;
            this.nameValuePairs.put(name, value);
        }
    }

    public JSONObject copy() {
        JSONObject dupe = new JSONObject();
        dupe.nameValuePairs.putAll(this.nameValuePairs);
        return dupe;
    }

    public JSONObject(Object ... keysAndValues) {
        this();
        int i = 0;
        while (i < keysAndValues.length) {
            this.put(keysAndValues[i++].toString(), keysAndValues[i++]);
        }
    }

    public int length() {
        return this.nameValuePairs.size();
    }

    public JSONObject put(String name, Object value) {
        if (value == null) {
            this.nameValuePairs.remove(name);
            return this;
        }
        JSONObject.testValidity(value);
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        this.nameValuePairs.put(this.checkName(name), value);
        return this;
    }

    public JSONObject accumulate(String name, Object value) {
        Object current = this.nameValuePairs.get(this.checkName(name));
        if (current == null) {
            return this.put(name, value);
        }
        if (current instanceof JSONArray) {
            JSONArray array = (JSONArray)current;
            array.checkedPut(value);
        } else {
            JSONArray array = new JSONArray();
            array.checkedPut(current);
            array.checkedPut(value);
            this.nameValuePairs.put(name, array);
        }
        return this;
    }

    public JSONObject append(String name, Object value) {
        JSONArray array;
        JSONObject.testValidity(value);
        Object current = this.nameValuePairs.get(this.checkName(name));
        if (current instanceof JSONArray) {
            array = (JSONArray)current;
        } else if (current == null) {
            JSONArray newArray = new JSONArray();
            this.nameValuePairs.put(name, newArray);
            array = newArray;
        } else {
            throw new RuntimeException("JSONObject[\"" + name + "\"] is not a JSONArray.");
        }
        array.checkedPut(value);
        return this;
    }

    String checkName(String name) {
        if (name == null) {
            throw new RuntimeException("Names must be non-null");
        }
        return name;
    }

    public Object remove(String name) {
        return this.nameValuePairs.remove(name);
    }

    public boolean isNull(String name) {
        Object value = this.nameValuePairs.get(name);
        return value == null || value == NULL;
    }

    public boolean has(String name) {
        return this.nameValuePairs.containsKey(name);
    }

    public Object get(String name) {
        Object result = this.nameValuePairs.get(name);
        if (result == null) {
            throw new RuntimeException("JSONObject[\"" + name + "\"] not found.");
        }
        return result;
    }

    public Object opt(String name) {
        return this.nameValuePairs.get(name);
    }

    public boolean getBoolean(String name) {
        Object object = this.get(name);
        Boolean result = JSON.toBoolean(object);
        if (result == null) {
            throw JSON.typeMismatch(false, name, object, "Boolean");
        }
        return result;
    }

    public double getDouble(String name) {
        Object object = this.get(name);
        Double result = JSON.toDouble(object);
        if (result == null) {
            throw JSON.typeMismatch(false, name, object, "number");
        }
        return result;
    }

    public int getInt(String name) {
        Object object = this.get(name);
        Integer result = JSON.toInteger(object);
        if (result == null) {
            throw JSON.typeMismatch(false, name, object, "int");
        }
        return result;
    }

    public long getLong(String name) {
        Object object = this.get(name);
        Long result = JSON.toLong(object);
        if (result == null) {
            throw JSON.typeMismatch(false, name, object, "long");
        }
        return result;
    }

    public String getString(String name) {
        Object object = this.get(name);
        String result = JSON.toString(object);
        if (result == null) {
            throw JSON.typeMismatch(false, name, object, "String");
        }
        return result;
    }

    public JSONArray getJSONArray(String name) {
        Object object = this.get(name);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSON.typeMismatch(false, name, object, "JSONArray");
    }

    public JSONObject getJSONObject(String name) {
        Object object = this.get(name);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSON.typeMismatch(false, name, object, "JSONObject");
    }

    public Set<String> keys() {
        return this.nameValuePairs.keySet();
    }

    public JSONArray names() {
        return this.nameValuePairs.isEmpty() ? null : JSONArray.from(this.nameValuePairs.keySet());
    }

    public static String numberToString(Number number) {
        if (number == null) {
            throw new RuntimeException("Number must be non-null");
        }
        double doubleValue = number.doubleValue();
        JSON.checkDouble(doubleValue);
        if (number.equals(NEGATIVE_ZERO)) {
            return "-0";
        }
        long longValue = number.longValue();
        if (doubleValue == (double)longValue) {
            return Long.toString(longValue);
        }
        return number.toString();
    }

    static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        return JSONObject.numberToString(d);
    }

    public static String quote(String data) {
        if (data == null) {
            return "\"\"";
        }
        try {
            JSONStringer stringer = new JSONStringer();
            stringer.open(JSONStringer.Scope.NULL, "");
            stringer.string(data);
            stringer.close(JSONStringer.Scope.NULL, JSONStringer.Scope.NULL, "");
            return stringer.toString();
        }
        catch (RuntimeException e) {
            throw new AssertionError();
        }
    }

    @Override
    void print(JSONPrintSession session) {
        session.printSymbol('{');
        session.indent();
        boolean comma = false;
        for (String key : this.keys()) {
            if (comma) {
                session.printSymbol(',');
            }
            session.newline();
            session.printQuoted(key);
            session.printSymbol(':');
            JSONObject.printValue(session, this.nameValuePairs.get(key));
            comma = true;
        }
        session.outdent();
        if (comma) {
            session.newline();
        }
        session.printSymbol('}');
    }

    static void printValue(JSONPrintSession session, Object value) {
        if (value == null || value == NULL) {
            session.print("null");
            return;
        }
        if (value instanceof JSONObject) {
            ((JSONObject)value).print(session);
            return;
        }
        if (value instanceof JSONArray) {
            ((JSONArray)value).print(session);
            return;
        }
        if (value instanceof JSONString) {
            String printValue = ((JSONString)value).toJSONString();
            session.print(printValue);
            return;
        }
        if (value instanceof Number) {
            String printValue = JSONObject.numberToString((Number)value);
            session.print(printValue);
            return;
        }
        if (value instanceof Boolean) {
            session.print(value.toString());
            return;
        }
        session.printQuoted(value.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONObject)) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        return this.nameValuePairs.equals(other.nameValuePairs);
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.nameValuePairs);
    }

    public JSONObject putAll(Map<String, ?> newProperties) {
        assert (newProperties != null);
        for (Map.Entry<String, ?> e : newProperties.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
        return this;
    }

    public JSONObject in(String key) {
        assert (key != null);
        Object nested = this.nameValuePairs.get(key);
        if (nested != null && !(nested instanceof JSONObject)) {
            throw new IllegalStateException(String.format("JSONObject[%s] is not a JSONObject.", JSONObject.quote(key)));
        }
        if (nested == null) {
            nested = new JSONObject();
            this.nameValuePairs.put(key, nested);
        }
        return (JSONObject)nested;
    }

    static void testValidity(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("null isn't valid in JSONObject and JSONArray. Use JSONObject.NULL instead.");
        }
        if (value == NULL) {
            return;
        }
        Class<?> clazz = value.getClass();
        if (Boolean.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || JSONArray.class.isAssignableFrom(clazz) || JSONLiteral.class.isAssignableFrom(clazz) || JSONObject.class.isAssignableFrom(clazz) || JSONString.class.isAssignableFrom(clazz)) {
            return;
        }
        throw new RuntimeException("JSONObject properties may be one of Boolean, Number, String, org.apache.tapestry5.json.JSONArray, org.apache.tapestry5.json.JSONLiteral, org.apache.tapestry5.json.JSONObject, org.apache.tapestry5.json.JSONObject$Null, org.apache.tapestry5.json.JSONString. Type " + clazz.getName() + " is not allowed.");
    }
}

