/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.ioc.internal.services.CompoundCoercion;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InheritanceSearch;
import org.apache.tapestry5.ioc.internal.util.InternalCommonsUtils;
import org.apache.tapestry5.ioc.internal.util.LockSupport;
import org.apache.tapestry5.ioc.services.Coercion;
import org.apache.tapestry5.ioc.services.CoercionTuple;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.util.StringToEnumCoercion;

public class TypeCoercerImpl
extends LockSupport
implements TypeCoercer {
    private final Map<Class, List<CoercionTuple>> sourceTypeToTuple = CollectionFactory.newMap();
    private final Map<Class, TargetCoercion> typeToTargetCoercion = new WeakHashMap<Class, TargetCoercion>();
    private static final Coercion NO_COERCION = new Coercion<Object, Object>(){

        @Override
        public Object coerce(Object input) {
            return input;
        }
    };
    private static final Coercion COERCION_NULL_TO_OBJECT = new Coercion<Void, Object>(){

        @Override
        public Object coerce(Void input) {
            return null;
        }

        public String toString() {
            return "null --> null";
        }
    };

    public TypeCoercerImpl(Collection<CoercionTuple> tuples) {
        for (CoercionTuple tuple : tuples) {
            Class key = tuple.getSourceType();
            InternalCommonsUtils.addToMapList(this.sourceTypeToTuple, key, tuple);
        }
    }

    public Object coerce(Object input, Class targetType) {
        assert (targetType != null);
        Class effectiveTargetType = PlasticUtils.toWrapperType((Class)targetType);
        if (effectiveTargetType.isInstance(input)) {
            return input;
        }
        return this.getTargetCoercion(effectiveTargetType).coerce(input);
    }

    @Override
    public <S, T> Coercion<S, T> getCoercion(Class<S> sourceType, Class<T> targetType) {
        assert (sourceType != null);
        assert (targetType != null);
        Class effectiveSourceType = PlasticUtils.toWrapperType(sourceType);
        Class effectiveTargetType = PlasticUtils.toWrapperType(targetType);
        if (effectiveTargetType.isAssignableFrom(effectiveSourceType)) {
            return NO_COERCION;
        }
        return this.getTargetCoercion(effectiveTargetType).getCoercion(effectiveSourceType);
    }

    @Override
    public <S, T> String explain(Class<S> sourceType, Class<T> targetType) {
        Class effectiveSourceType;
        assert (sourceType != null);
        assert (targetType != null);
        Class effectiveTargetType = PlasticUtils.toWrapperType(targetType);
        if (effectiveTargetType.isAssignableFrom(effectiveSourceType = PlasticUtils.toWrapperType(sourceType))) {
            return "";
        }
        return this.getTargetCoercion(effectiveTargetType).explain(effectiveSourceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TargetCoercion getTargetCoercion(Class targetType) {
        try {
            this.acquireReadLock();
            TargetCoercion tc = this.typeToTargetCoercion.get(targetType);
            TargetCoercion targetCoercion = tc != null ? tc : this.createAndStoreNewTargetCoercion(targetType);
            return targetCoercion;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TargetCoercion createAndStoreNewTargetCoercion(Class targetType) {
        try {
            this.upgradeReadLockToWriteLock();
            TargetCoercion tc = this.typeToTargetCoercion.get(targetType);
            if (tc == null) {
                tc = new TargetCoercion(targetType);
                this.typeToTargetCoercion.put(targetType, tc);
            }
            TargetCoercion targetCoercion = tc;
            return targetCoercion;
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    @Override
    public void clearCache() {
        try {
            this.acquireReadLock();
            for (TargetCoercion tc : this.typeToTargetCoercion.values()) {
                tc.clearCache();
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    private Coercion findOrCreateCoercion(Class sourceType, Class targetType) {
        if (sourceType == Void.class) {
            return this.searchForNullCoercion(targetType);
        }
        Set<CoercionTuple> consideredTuples = CollectionFactory.newSet();
        LinkedList<CoercionTuple> queue = CollectionFactory.newLinkedList();
        this.seedQueue(sourceType, targetType, consideredTuples, queue);
        while (!queue.isEmpty()) {
            CoercionTuple tuple = queue.removeFirst();
            Class tupleTargetType = tuple.getTargetType();
            if (targetType.isAssignableFrom(tupleTargetType)) {
                return tuple.getCoercion();
            }
            this.queueIntermediates(sourceType, targetType, tuple, consideredTuples, queue);
        }
        throw new UnknownValueException(String.format("Could not find a coercion from type %s to type %s.", sourceType.getName(), targetType.getName()), this.buildCoercionCatalog());
    }

    private Coercion searchForNullCoercion(Class targetType) {
        List<CoercionTuple> tuples = this.getTuples(Void.class, targetType);
        for (CoercionTuple tuple : tuples) {
            Class tupleTargetType = tuple.getTargetType();
            if (!targetType.equals(tupleTargetType)) continue;
            return tuple.getCoercion();
        }
        return COERCION_NULL_TO_OBJECT;
    }

    private AvailableValues buildCoercionCatalog() {
        List masterList = CollectionFactory.newList();
        for (List<CoercionTuple> list : this.sourceTypeToTuple.values()) {
            masterList.addAll(list);
        }
        return new AvailableValues("Configured coercions", masterList);
    }

    private void seedQueue(Class sourceType, Class targetType, Set<CoercionTuple> consideredTuples, LinkedList<CoercionTuple> queue) {
        for (Class c : new InheritanceSearch(sourceType)) {
            List<CoercionTuple> tuples = this.getTuples(c, targetType);
            if (tuples == null) continue;
            for (CoercionTuple tuple : tuples) {
                queue.addLast(tuple);
                consideredTuples.add(tuple);
            }
            if (sourceType != Void.class) continue;
            return;
        }
    }

    private void queueIntermediates(Class sourceType, Class targetType, CoercionTuple intermediateTuple, Set<CoercionTuple> consideredTuples, LinkedList<CoercionTuple> queue) {
        Class intermediateType = intermediateTuple.getTargetType();
        for (Class c : new InheritanceSearch(intermediateType)) {
            for (CoercionTuple tuple : this.getTuples(c, targetType)) {
                Class newIntermediateType;
                if (consideredTuples.contains(tuple) || sourceType.isAssignableFrom(newIntermediateType = tuple.getTargetType())) continue;
                CompoundCoercion compoundCoercer = new CompoundCoercion(intermediateTuple.getCoercion(), tuple.getCoercion());
                CoercionTuple compoundTuple = new CoercionTuple(sourceType, newIntermediateType, compoundCoercer, false);
                queue.addLast(compoundTuple);
                consideredTuples.add(tuple);
            }
        }
    }

    private List<CoercionTuple> getTuples(Class sourceType, Class targetType) {
        List tuples = this.sourceTypeToTuple.get(sourceType);
        if (tuples == null) {
            tuples = Collections.emptyList();
        }
        if (sourceType == String.class && Enum.class.isAssignableFrom(targetType)) {
            tuples = TypeCoercerImpl.extend(tuples, new CoercionTuple(sourceType, targetType, new StringToEnumCoercion(targetType)));
        }
        return tuples;
    }

    private static <T> List<T> extend(List<T> list, T extraValue) {
        return F.flow(list).append(new Object[]{extraValue}).toList();
    }

    private class TargetCoercion {
        private final Class type;
        private final Map<Class, Coercion> cache = CollectionFactory.newConcurrentMap();

        TargetCoercion(Class type) {
            this.type = type;
        }

        void clearCache() {
            this.cache.clear();
        }

        Object coerce(Object input) {
            Class sourceType;
            Class clazz = sourceType = input != null ? input.getClass() : Void.class;
            if (this.type.isAssignableFrom(sourceType)) {
                return input;
            }
            Coercion c = this.getCoercion(sourceType);
            try {
                return this.type.cast(c.coerce(input));
            }
            catch (Exception ex) {
                throw new RuntimeException(ServiceMessages.failedCoercion(input, this.type, c, ex), ex);
            }
        }

        String explain(Class sourceType) {
            return this.getCoercion(sourceType).toString();
        }

        private Coercion getCoercion(Class sourceType) {
            Coercion c = this.cache.get(sourceType);
            if (c == null) {
                c = TypeCoercerImpl.this.findOrCreateCoercion(sourceType, this.type);
                this.cache.put(sourceType, c);
            }
            return c;
        }
    }
}

