/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import org.apache.tapestry5.internal.plastic.ClassLoaderDelegate;

public class PlasticClassLoader
extends ClassLoader {
    private final ClassLoaderDelegate delegate;

    public PlasticClassLoader(ClassLoader parent, ClassLoaderDelegate delegate) {
        super(parent);
        this.delegate = delegate;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        if (this.delegate.shouldInterceptClassLoading(name)) {
            Class<?> c = this.delegate.loadAndTransformClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        return super.loadClass(name, resolve);
    }

    public synchronized Class<?> defineClassWithBytecode(String className, byte[] bytecode) {
        return this.defineClass(className, bytecode, 0, bytecode.length);
    }
}

