/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.beaneditor;

import java.lang.annotation.Annotation;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.beaneditor.Sortable;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.internal.util.InternalCommonsUtils;
import org.apache.tapestry5.plastic.PlasticUtils;

public class PropertyModelImpl
implements PropertyModel {
    private final BeanModel model;
    private final String name;
    private final PropertyConduit conduit;
    private final String id;
    private String label;
    private String dataType;
    private boolean sortable;

    public PropertyModelImpl(BeanModel model, String name, PropertyConduit conduit, Messages messages) {
        this.model = model;
        this.name = name;
        this.conduit = conduit;
        this.id = InternalCommonsUtils.extractIdFromPropertyExpression((String)name);
        this.label = InternalCommonsUtils.defaultLabel((String)this.id, (Messages)messages, (String)name);
        if (conduit != null) {
            Sortable sortableAnnotation = (Sortable)conduit.getAnnotation(Sortable.class);
            if (sortableAnnotation != null) {
                this.sortable = sortableAnnotation.value();
            } else {
                Class wrapperType = PlasticUtils.toWrapperType((Class)this.getPropertyType());
                this.sortable = Comparable.class.isAssignableFrom(wrapperType);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Class getPropertyType() {
        return this.conduit == null ? Object.class : this.conduit.getPropertyType();
    }

    @Override
    public PropertyConduit getConduit() {
        return this.conduit;
    }

    @Override
    public PropertyModel label(String label) {
        assert (InternalCommonsUtils.isNonBlank((String)label));
        this.label = label;
        return this;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public BeanModel model() {
        return this.model;
    }

    @Override
    public PropertyModel dataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public PropertyModel sortable(boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)(this.conduit == null ? null : this.conduit.getAnnotation(annotationClass));
    }
}

