/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.util.Set;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;

public class InheritanceData {
    private final InheritanceData parent;
    private final Set<String> methodNames = PlasticInternalUtils.newSet();
    private final Set<String> methods = PlasticInternalUtils.newSet();
    private final Set<String> interfaceNames = PlasticInternalUtils.newSet();

    public InheritanceData() {
        this(null);
    }

    private InheritanceData(InheritanceData parent) {
        this.parent = parent;
    }

    public boolean isTransformed() {
        return this.parent != null;
    }

    public InheritanceData createChild() {
        return new InheritanceData(this);
    }

    public void addMethod(String name, String desc) {
        this.methods.add(InheritanceData.toValue(name, desc));
        this.methodNames.add(name);
    }

    public boolean isImplemented(String name, String desc) {
        return this.checkForMethod(InheritanceData.toValue(name, desc));
    }

    private boolean checkForMethod(String value) {
        InheritanceData cursor = this;
        while (cursor != null) {
            if (cursor.methods.contains(value)) {
                return true;
            }
            cursor = cursor.parent;
        }
        return false;
    }

    public boolean isInterfaceImplemented(String name) {
        InheritanceData cursor = this;
        while (cursor != null) {
            if (cursor.interfaceNames.contains(name)) {
                return true;
            }
            cursor = cursor.parent;
        }
        return false;
    }

    public void addInterface(String name) {
        if (!this.interfaceNames.contains(name)) {
            this.interfaceNames.add(name);
        }
    }

    private static String toValue(String name, String desc) {
        int endOfParameterSpecIdx = desc.indexOf(41);
        return name + ":" + desc.substring(0, endOfParameterSpecIdx + 1);
    }

    public Set<String> methodNames() {
        Set<String> result = PlasticInternalUtils.newSet();
        InheritanceData cursor = this;
        while (cursor != null) {
            result.addAll(cursor.methodNames);
            cursor = cursor.parent;
        }
        return result;
    }
}

