(function() {
  define(["./dom", "./ajax", "underscore", "jquery", "./utils", "./typeahead"], function(dom, ajax, _, $, _arg) {
    var exports, extendURL, init;
    extendURL = _arg.extendURL;
    init = function(spec) {
      var $field, dataset, engine;
      $field = $(document.getElementById(spec.id));
      engine = new Bloodhound({
        datumTokenizer: Bloodhound.tokenizers.whitespace,
        queryTokenizer: Bloodhound.tokenizers.whitespace,
        limit: spec.limit,
        remote: {
          url: spec.url,
          replace: function(uri, query) {
            return extendURL(uri, {
              "t:input": query
            });
          },
          filter: function(response) {
            return response.matches;
          }
        }
      });
      engine.initialize();
      dataset = {
        name: spec.id,
        displayKey: _.identity,
        source: engine.ttAdapter()
      };
      return $field.typeahead({
        minLength: spec.minChars
      }, dataset);
    };
    return exports = init;
  });

}).call(this);
