/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.func;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.tapestry5.func.ArrayFlow;
import org.apache.tapestry5.func.EmptyFlow;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.LazyContinuation;
import org.apache.tapestry5.func.LazyFlow;
import org.apache.tapestry5.func.LazyFunction;
import org.apache.tapestry5.func.LazyIterator;
import org.apache.tapestry5.func.LazyRange;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Mapper2;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.func.Reducer;
import org.apache.tapestry5.func.Tuple;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.func.ZippedFlow;
import org.apache.tapestry5.func.ZippedFlowImpl;

public class F {
    static final Flow<?> EMPTY_FLOW = new EmptyFlow();
    public static Predicate<String> IS_BLANK = new Predicate<String>(){

        @Override
        public boolean accept(String element) {
            return element == null || element.trim().length() == 0;
        }
    };
    public static Reducer<Integer, Integer> SUM_INTS = new Reducer<Integer, Integer>(){

        @Override
        public Integer reduce(Integer accumulator, Integer value) {
            return accumulator + value;
        }
    };
    public static Mapper2<Integer, Integer, Integer> ADD_INTS = new Mapper2<Integer, Integer, Integer>(){

        @Override
        public Integer map(Integer first, Integer second) {
            return first + second;
        }
    };

    static <T> Flow<T> emptyFlow() {
        return EMPTY_FLOW;
    }

    public static <T> Predicate<T> eql(final T value) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T element) {
                return element.equals(value);
            }
        };
    }

    public static <T extends Comparable<T>> Predicate<T> eq(final T value) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T element) {
                return element.compareTo((Comparable)value) == 0;
            }
        };
    }

    public static <T extends Comparable<T>> Predicate<T> neq(final T value) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T object) {
                return object.compareTo((Comparable)value) != 0;
            }
        };
    }

    public static <T extends Comparable<T>> Predicate<T> gt(final T value) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T element) {
                return element.compareTo((Comparable)value) > 0;
            }
        };
    }

    public static <T extends Comparable<T>> Predicate<T> gteq(final T value) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T element) {
                return element.compareTo((Comparable)value) >= 0;
            }
        };
    }

    public static <T extends Comparable<T>> Predicate<T> lt(T value) {
        return F.not(F.gteq(value));
    }

    public static <T extends Comparable<T>> Predicate<T> lteq(T value) {
        return F.not(F.gt(value));
    }

    public static <T> Predicate<T> isNull() {
        return new Predicate<T>(){

            @Override
            public boolean accept(T element) {
                return element == null;
            }
        };
    }

    public static <T> Predicate<T> notNull() {
        return F.not(F.<T>isNull());
    }

    public static <T> Mapper<T, String> stringValueOf() {
        return new Mapper<T, String>(){

            @Override
            public String map(T value) {
                return String.valueOf(value);
            }
        };
    }

    public static <S, T> Mapper<S, T> always(final T fixedResult) {
        return new Mapper<S, T>(){

            @Override
            public T map(S input) {
                return fixedResult;
            }
        };
    }

    public static <S, T> Mapper<S, T> select(final Predicate<? super S> predicate, final Mapper<S, T> ifAccepted, final Mapper<S, T> ifRejected) {
        assert (predicate != null);
        assert (ifAccepted != null);
        assert (ifRejected != null);
        return new Mapper<S, T>(){

            @Override
            public T map(S input) {
                Mapper active = predicate.accept(input) ? ifAccepted : ifRejected;
                return active.map(input);
            }
        };
    }

    public static <S, T> Mapper<S, T> select(Predicate<? super S> predicate, Mapper<S, T> ifAccepted) {
        return F.select(predicate, ifAccepted, (Object)null);
    }

    public static <S, T> Mapper<S, T> select(Predicate<? super S> predicate, Mapper<S, T> ifAccepted, T ifRejectedValue) {
        Mapper<S, T> rejectedMapper = F.always(ifRejectedValue);
        return F.select(predicate, ifAccepted, rejectedMapper);
    }

    public static <S> Mapper<S, S> identity() {
        return new Mapper<S, S>(){

            @Override
            public S map(S input) {
                return input;
            }
        };
    }

    public static <S> Predicate<S> toPredicate(final Mapper<S, Boolean> mapper) {
        assert (mapper != null);
        return new Predicate<S>(){

            @Override
            public boolean accept(S object) {
                return (Boolean)mapper.map(object);
            }
        };
    }

    public static <T> Flow<T> flow(Collection<T> values) {
        assert (values != null);
        if (values.isEmpty()) {
            return F.emptyFlow();
        }
        return new ArrayFlow<T>(values);
    }

    public static <T> Flow<T> flow(T ... values) {
        if (values.length == 0) {
            return F.emptyFlow();
        }
        return new ArrayFlow<T>(values);
    }

    public static <T> Flow<T> flow(Iterable<T> iterable) {
        assert (iterable != null);
        return F.flow(iterable.iterator());
    }

    public static <T> Flow<T> flow(Iterator<T> iterator) {
        return F.lazy(new LazyIterator<T>(iterator));
    }

    public static <A, B> ZippedFlow<A, B> zippedFlow(Map<A, B> map) {
        assert (map != null);
        Flow tuples = F.flow(map.entrySet()).map(new Mapper<Map.Entry<A, B>, Tuple<A, B>>(){

            @Override
            public Tuple<A, B> map(Map.Entry<A, B> element) {
                return Tuple.create(element.getKey(), element.getValue());
            }
        });
        return ZippedFlowImpl.create(tuples);
    }

    public static Flow<Integer> range(int lower, int upper) {
        if (lower == upper) {
            return F.emptyFlow();
        }
        if (lower < upper) {
            return F.lazy(new LazyRange(lower, upper, 1));
        }
        return F.lazy(new LazyRange(lower, upper, -1));
    }

    public static <T> Flow<T> lazy(LazyFunction<T> function) {
        assert (function != null);
        return new LazyFlow<T>(function);
    }

    private static <T> LazyFunction<T> toLazyFunction(final T currentValue, final Mapper<T, T> function) {
        return new LazyFunction<T>(){

            @Override
            public LazyContinuation<T> next() {
                Object nextValue = function.map(currentValue);
                return new LazyContinuation(nextValue, F.toLazyFunction(nextValue, function));
            }
        };
    }

    public static <T> Flow<T> iterate(final T initial, final Mapper<T, T> function) {
        LazyFunction head = new LazyFunction<T>(){

            @Override
            public LazyContinuation<T> next() {
                return new LazyContinuation<Object>(initial, F.toLazyFunction(initial, function));
            }
        };
        return F.lazy(head);
    }

    public static Flow<Integer> series(int start, final int delta) {
        return F.iterate(start, new Mapper<Integer, Integer>(){

            @Override
            public Integer map(Integer element) {
                return element + delta;
            }
        });
    }

    public static <T> Worker<T> addToCollection(final Collection<T> coll) {
        return new Worker<T>(){

            @Override
            public void work(T value) {
                coll.add(value);
            }
        };
    }

    public static Predicate<String> startsWith(String prefix) {
        return F.startsWith(prefix, false);
    }

    public static Predicate<String> startsWithIgnoringCase(String prefix) {
        return F.startsWith(prefix, true);
    }

    private static Predicate<String> startsWith(final String prefix, final boolean ignoreCase) {
        return new Predicate<String>(){

            @Override
            public boolean accept(String element) {
                return element.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
            }
        };
    }

    public static Predicate<String> endsWith(String suffix) {
        return F.endsWith(suffix, false);
    }

    public static Predicate<String> endsWithIgnoringCase(String suffix) {
        return F.endsWith(suffix, true);
    }

    private static Predicate<String> endsWith(final String suffix, final boolean ignoreCase) {
        return new Predicate<String>(){

            @Override
            public boolean accept(String element) {
                return element.regionMatches(ignoreCase, element.length() - suffix.length(), suffix, 0, suffix.length());
            }
        };
    }

    public static <A extends Comparable<A>, B> Comparator<Tuple<A, B>> orderByFirst() {
        return new Comparator<Tuple<A, B>>(){

            @Override
            public int compare(Tuple<A, B> o1, Tuple<A, B> o2) {
                return ((Comparable)o1.first).compareTo(o2.first);
            }
        };
    }

    public static <A, B extends Comparable<B>> Comparator<Tuple<A, B>> orderBySecond() {
        return new Comparator<Tuple<A, B>>(){

            @Override
            public int compare(Tuple<A, B> o1, Tuple<A, B> o2) {
                return ((Comparable)o1.second).compareTo(o2.second);
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<? super T> delegate) {
        assert (delegate != null);
        return new Predicate<T>(){

            @Override
            public boolean accept(T element) {
                return !delegate.accept(element);
            }
        };
    }

    public static <A, B, C> Mapper<A, C> combine(final Mapper<A, B> abMapper, final Mapper<B, C> bcMapper) {
        assert (abMapper != null);
        assert (bcMapper != null);
        return new Mapper<A, C>(){

            @Override
            public C map(A aElement) {
                Object bElement = abMapper.map(aElement);
                return bcMapper.map(bElement);
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<? super T> ... delegates) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T element) {
                for (Predicate delegate : delegates) {
                    if (delegate.accept(element)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> ... delegates) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T element) {
                for (Predicate delegate : delegates) {
                    if (!delegate.accept(element)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Worker<T> combine(final Worker<? super T> ... delegates) {
        assert (delegates.length > 0);
        return new Worker<T>(){

            @Override
            public void work(T value) {
                for (Worker delegate : delegates) {
                    delegate.work(value);
                }
            }
        };
    }
}

