/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.Dispatcher;
import org.apache.tapestry5.services.PathConstructor;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.javascript.ModuleManager;

public class ModuleDispatcher
implements Dispatcher {
    private final ModuleManager moduleManager;
    private final ResourceStreamer streamer;
    private final OperationTracker tracker;
    private final String requestPrefix;
    private final boolean compress;
    private final Set<ResourceStreamer.Options> omitExpiration = EnumSet.of(ResourceStreamer.Options.OMIT_EXPIRATION);

    public ModuleDispatcher(ModuleManager moduleManager, ResourceStreamer streamer, OperationTracker tracker, PathConstructor pathConstructor, String prefix, boolean compress) {
        this.moduleManager = moduleManager;
        this.streamer = streamer;
        this.tracker = tracker;
        this.compress = compress;
        this.requestPrefix = pathConstructor.constructDispatchPath(compress ? prefix + ".gz" : prefix) + "/";
    }

    @Override
    public boolean dispatch(Request request, Response response) throws IOException {
        String path = request.getPath();
        if (path.startsWith(this.requestPrefix)) {
            String extraPath = path.substring(this.requestPrefix.length());
            if (!this.handleModuleRequest(extraPath)) {
                response.sendError(404, String.format("No module for path '%s'.", extraPath));
            }
            return true;
        }
        return false;
    }

    private boolean handleModuleRequest(String extraPath) throws IOException {
        int dotx = extraPath.lastIndexOf(46);
        if (dotx < 0) {
            return false;
        }
        if (!extraPath.substring(dotx + 1).equals("js")) {
            return false;
        }
        final String moduleName = extraPath.substring(0, dotx);
        return (Boolean)this.tracker.perform(String.format("Streaming %s %s", this.compress ? "compressed module" : "module", moduleName), (IOOperation)new IOOperation<Boolean>(){

            public Boolean perform() throws IOException {
                Resource resource = ModuleDispatcher.this.moduleManager.findResourceForModule(moduleName);
                if (resource != null) {
                    return ModuleDispatcher.this.streamer.streamResource(resource, ModuleDispatcher.this.compress ? "z" : "", (Set<ResourceStreamer.Options>)ModuleDispatcher.this.omitExpiration);
                }
                return false;
            }
        });
    }
}

