/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.assets.ChecksumPath;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.assets.AssetRequestHandler;

public class ClasspathAssetRequestHandler
implements AssetRequestHandler {
    private final ResourceStreamer streamer;
    private final AssetSource assetSource;
    private final String baseFolder;

    public ClasspathAssetRequestHandler(ResourceStreamer streamer, AssetSource assetSource, String baseFolder) {
        this.streamer = streamer;
        this.assetSource = assetSource;
        this.baseFolder = baseFolder;
    }

    @Override
    public boolean handleAssetRequest(Request request, Response response, String extraPath) throws IOException {
        ChecksumPath path = new ChecksumPath(this.streamer, this.baseFolder, extraPath);
        Resource resource = this.assetSource.resourceForPath(path.resourcePath);
        return path.stream(resource);
    }
}

