/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.BitSet;
import org.apache.tapestry5.services.URLEncoder;

public class URLEncoderImpl
implements URLEncoder {
    static final String ENCODED_NULL = "$N";
    static final String ENCODED_BLANK = "$B";
    private final BitSet safe = new BitSet(128);

    public URLEncoderImpl() {
        this.markSafe("abcdefghijklmnopqrstuvwxyz");
        this.markSafe("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        this.markSafe("01234567890-_.:");
    }

    private void markSafe(String s) {
        for (char ch : s.toCharArray()) {
            this.safe.set(ch);
        }
    }

    @Override
    public String encode(String input) {
        if (input == null) {
            return ENCODED_NULL;
        }
        if (input.equals("")) {
            return ENCODED_BLANK;
        }
        boolean dirty = false;
        int length = input.length();
        StringBuilder output = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            if (ch == '$') {
                output.append("$$");
                dirty = true;
                continue;
            }
            char chAsInt = ch;
            if (this.safe.get(chAsInt)) {
                output.append(ch);
                continue;
            }
            output.append(String.format("$%04x", chAsInt));
            dirty = true;
        }
        return dirty ? output.toString() : input;
    }

    @Override
    public String decode(String input) {
        assert (input != null);
        if (input.equals(ENCODED_NULL)) {
            return null;
        }
        if (input.equals(ENCODED_BLANK)) {
            return "";
        }
        boolean dirty = false;
        int length = input.length();
        StringBuilder output = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            if (ch == '$') {
                dirty = true;
                if (i + 1 < length && input.charAt(i + 1) == '$') {
                    output.append('$');
                    ++i;
                    dirty = true;
                    continue;
                }
                if (i + 4 < length) {
                    String hex = input.substring(i + 1, i + 5);
                    try {
                        int unicode = Integer.parseInt(hex, 16);
                        output.append((char)unicode);
                        i += 4;
                        dirty = true;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException(String.format("Input string '%s' is not valid; the '$' character at position %d should be followed by another '$' or a four digit hex number (a unicode value).", input, i + 1));
            }
            if (!this.safe.get(ch)) {
                throw new IllegalArgumentException(String.format("Input string '%s' is not valid; the character '%s' at position %d is not valid.", input, Character.valueOf(ch), i + 1));
            }
            output.append(ch);
        }
        return dirty ? output.toString() : input;
    }
}

