/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.AbstractResource;
import org.apache.tapestry5.services.Context;

public class ContextResource
extends AbstractResource {
    private static final int PRIME = 37;
    private final Context context;
    private URL url;
    private boolean urlResolved;

    public ContextResource(Context context, String path) {
        super(path);
        assert (context != null);
        this.context = context;
    }

    public String toString() {
        return String.format("context:%s", this.getPath());
    }

    protected Resource newResource(String path) {
        return new ContextResource(this.context, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL toURL() {
        try {
            this.acquireReadLock();
            if (!this.urlResolved) {
                this.resolveURL();
            }
            URL uRL = this.url;
            return uRL;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveURL() {
        block9: {
            this.upgradeReadLockToWriteLock();
            if (this.urlResolved) {
                return;
            }
            String contextPath = "/" + this.getPath();
            File file = this.context.getRealFile(contextPath);
            if (file != null && file.exists()) {
                try {
                    this.url = file.toURI().toURL();
                    this.validateURL(this.url);
                    this.urlResolved = true;
                    return;
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.url = this.context.getResource(contextPath);
            break block9;
            finally {
                this.downgradeWriteLockToReadLock();
            }
        }
        this.validateURL(this.url);
        this.urlResolved = true;
    }

    public int hashCode() {
        return 37 * this.context.hashCode() + this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ContextResource other = (ContextResource)((Object)obj);
        return this.context == other.context && this.getPath().equals(other.getPath());
    }
}

