/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.pages;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.annotations.ContentType;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.UnknownActivationContextCheck;
import org.apache.tapestry5.corelib.base.AbstractInternalPage;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.PageActivationContextCollector;
import org.apache.tapestry5.internal.services.ReloadHelper;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.BaseURLSource;
import org.apache.tapestry5.services.ExceptionReporter;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Session;
import org.apache.tapestry5.services.URLEncoder;

@UnknownActivationContextCheck(value=false)
@ContentType(value="text/html")
@Import(stylesheet={"ExceptionReport.css"})
public class ExceptionReport
extends AbstractInternalPage
implements ExceptionReporter {
    private static final String PATH_SEPARATOR_PROPERTY = "path.separator";
    private static final Pattern PATH_RECOGNIZER = Pattern.compile("\\..*path$");
    @Property
    private String attributeName;
    @Inject
    @Symbol(value="tapestry.production-mode")
    @Property(write=false)
    private boolean productionMode;
    @Inject
    @Symbol(value="tapestry.version")
    @Property(write=false)
    private String tapestryVersion;
    @Inject
    @Symbol(value="tapestry.application-version")
    @Property(write=false)
    private String applicationVersion;
    @Property(write=false)
    private Throwable rootException;
    @Property
    private String propertyName;
    @Property
    private String failurePage;
    @Inject
    private RequestGlobals requestGlobals;
    @Inject
    private AlertManager alertManager;
    @Inject
    private PageActivationContextCollector pageActivationContextCollector;
    @Inject
    private PageRenderLinkSource linkSource;
    @Inject
    private BaseURLSource baseURLSource;
    @Inject
    private ReloadHelper reloadHelper;
    @Inject
    private URLEncoder urlEncoder;
    @Property
    private String rootURL;
    @Property
    private ThreadInfo thread;
    private final String pathSeparator = System.getProperty("path.separator");

    public boolean isShowActions() {
        return !this.request.isXHR();
    }

    public boolean isShowReload() {
        return !this.productionMode;
    }

    @Override
    public void reportException(Throwable exception) {
        this.rootException = exception;
        this.failurePage = this.request.getAttribute("tapestry.active-page-loaded") == null ? null : this.requestGlobals.getActivePageName();
        this.rootURL = this.baseURLSource.getBaseURL(this.request.isSecure());
    }

    public Object[] getReloadContext() {
        return this.pageActivationContextCollector.collectPageActivationContext(this.failurePage);
    }

    Object onActionFromReloadFirst(EventContext reloadContext) {
        this.reloadHelper.forceReload();
        return this.linkSource.createPageRenderLinkWithContext(this.urlEncoder.decode(this.request.getParameter("loadPage")), reloadContext);
    }

    Object onActionFromReloadRoot() throws MalformedURLException {
        this.reloadHelper.forceReload();
        return new URL(this.baseURLSource.getBaseURL(this.request.isSecure()));
    }

    public boolean getHasSession() {
        return this.request.getSession(false) != null;
    }

    public Session getSession() {
        return this.request.getSession(false);
    }

    public Object getAttributeValue() {
        return this.getSession().getAttribute(this.attributeName);
    }

    public List<String> getSystemProperties() {
        return InternalUtils.sortedKeys((Map)System.getProperties());
    }

    public String getPropertyValue() {
        return System.getProperty(this.propertyName);
    }

    public boolean isComplexProperty() {
        return PATH_RECOGNIZER.matcher(this.propertyName).find() && this.getPropertyValue().contains(this.pathSeparator);
    }

    public String[] getComplexPropertyValue() {
        return this.getPropertyValue().split(this.pathSeparator);
    }

    public List<ThreadInfo> getThreads() {
        return F.flow((Object[])TapestryInternalUtils.getAllThreads()).map((Mapper)new Mapper<Thread, ThreadInfo>(){

            public ThreadInfo map(Thread t) {
                List flags = CollectionFactory.newList();
                if (t.isDaemon()) {
                    flags.add("daemon");
                }
                if (!t.isAlive()) {
                    flags.add("NOT alive");
                }
                if (t.isInterrupted()) {
                    flags.add("interrupted");
                }
                if (t.getPriority() != 5) {
                    flags.add("priority " + t.getPriority());
                }
                return new ThreadInfo(Thread.currentThread() == t ? "active-thread" : "", t.getName(), t.getState().name(), InternalUtils.join((List)flags), t.getThreadGroup());
            }
        }).sort().toList();
    }

    public class ThreadInfo
    implements Comparable<ThreadInfo> {
        public final String className;
        public final String name;
        public final String state;
        public final String flags;
        public final ThreadGroup group;

        public ThreadInfo(String className, String name, String state, String flags, ThreadGroup group) {
            this.className = className;
            this.name = name;
            this.state = state;
            this.flags = flags;
            this.group = group;
        }

        @Override
        public int compareTo(ThreadInfo o) {
            return this.name.compareTo(o.name);
        }
    }
}

