/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationDecorator;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.HeartbeatDeferred;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

@SupportsInformalParameters
public class Label {
    @Parameter(name="for", required=true, allowNull=false, defaultPrefix="component")
    private Field field;
    @Environmental
    private ValidationDecorator decorator;
    @Inject
    private ComponentResources resources;
    @Parameter
    private boolean ignoreBody;
    private Element labelElement;

    boolean beginRender(MarkupWriter writer) {
        this.decorator.beforeLabel(this.field);
        this.labelElement = writer.element("label", "class", "control-label");
        this.resources.renderInformalParameters(writer);
        this.updateAttributes();
        return !this.ignoreBody;
    }

    @HeartbeatDeferred
    private void updateAttributes() {
        String fieldId = this.field.getClientId();
        this.labelElement.forceAttributes("for", fieldId);
        this.decorator.insideLabel(this.field, this.labelElement);
    }

    void afterRender(MarkupWriter writer) {
        boolean bodyIsBlank = InternalUtils.isBlank((String)this.labelElement.getChildMarkup());
        if (bodyIsBlank) {
            writer.write(this.field.getLabel());
        }
        writer.end();
        this.decorator.afterLabel(this.field);
    }
}

