/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry5.internal.services.AnnotationDataTypeAnalyzer;
import org.apache.tapestry5.internal.services.DefaultDataTypeAnalyzer;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.services.DataTypeAnalyzer;

public class BasicDataTypeAnalyzers {
    public static void contributeDataTypeAnalyzer(OrderedConfiguration<DataTypeAnalyzer> configuration, DataTypeAnalyzer defaultDataTypeAnalyzer) {
        configuration.add("Annotation", new AnnotationDataTypeAnalyzer(), new String[0]);
        if (defaultDataTypeAnalyzer == null) {
            defaultDataTypeAnalyzer = BasicDataTypeAnalyzers.createDefaultDataTypeAnalyzer();
        }
        configuration.add("Default", defaultDataTypeAnalyzer, "after:*");
    }

    public static DataTypeAnalyzer createDefaultDataTypeAnalyzer() {
        DefaultDataTypeAnalyzerMappedConfiguration mappedConfiguration = new DefaultDataTypeAnalyzerMappedConfiguration();
        BasicDataTypeAnalyzers.provideDefaultDataTypeAnalyzers(mappedConfiguration);
        return new CombinedDataTypeAnalyzer(new AnnotationDataTypeAnalyzer(), new DefaultDataTypeAnalyzer(mappedConfiguration.getMap()));
    }

    public static void provideDefaultDataTypeAnalyzers(MappedConfiguration<Class, String> configuration) {
        configuration.add(Object.class, "");
        configuration.add(String.class, "text");
        configuration.add(Number.class, "number");
        configuration.add(Enum.class, "enum");
        configuration.add(Boolean.class, "boolean");
        configuration.add(Date.class, "date");
        configuration.add(Calendar.class, "calendar");
    }

    private static final class CombinedDataTypeAnalyzer
    implements DataTypeAnalyzer {
        private final DataTypeAnalyzer[] analyzers;

        public CombinedDataTypeAnalyzer(DataTypeAnalyzer ... analyzers) {
            this.analyzers = analyzers;
        }

        @Override
        public String identifyDataType(PropertyAdapter adapter) {
            DataTypeAnalyzer analyzer;
            String type = null;
            DataTypeAnalyzer[] arr$ = this.analyzers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (type = (analyzer = arr$[i$]).identifyDataType(adapter)) == null; ++i$) {
            }
            return type;
        }
    }

    private static final class DefaultDataTypeAnalyzerMappedConfiguration
    implements MappedConfiguration<Class, String> {
        final Map<Class, String> map = new HashMap<Class, String>();

        private DefaultDataTypeAnalyzerMappedConfiguration() {
        }

        @Override
        public void add(Class key, String value) {
            this.map.put(key, value);
        }

        @Override
        public void override(Class key, String value) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void addInstance(Class key, Class<? extends String> clazz) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void overrideInstance(Class key, Class<? extends String> clazz) {
            throw new RuntimeException("Not implemented");
        }

        public Map<Class, String> getMap() {
            return this.map;
        }
    }
}

