/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.upload.internal.services;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.apache.tapestry5.upload.internal.services.ParametersServletRequestWrapper;
import org.apache.tapestry5.upload.internal.services.UploadedFileItem;
import org.apache.tapestry5.upload.services.MultipartDecoder;
import org.apache.tapestry5.upload.services.UploadedFile;

public class MultipartDecoderImpl
implements MultipartDecoder,
ThreadCleanupListener {
    private final Map<String, UploadedFileItem> uploads = CollectionFactory.newMap();
    private final FileItemFactory fileItemFactory;
    private final long maxRequestSize;
    private final long maxFileSize;
    private final String requestEncoding;
    private FileUploadException uploadException;

    public MultipartDecoderImpl(FileItemFactory fileItemFactory, @Symbol(value="upload.requestsize-max") long maxRequestSize, @Symbol(value="upload.filesize-max") long maxFileSize, @Symbol(value="tapestry.charset") String requestEncoding) {
        this.fileItemFactory = fileItemFactory;
        this.maxRequestSize = maxRequestSize;
        this.maxFileSize = maxFileSize;
        this.requestEncoding = requestEncoding;
    }

    @Override
    public UploadedFile getFileUpload(String parameterName) {
        return this.uploads.get(parameterName);
    }

    @Override
    public HttpServletRequest decode(HttpServletRequest request) {
        try {
            request.setCharacterEncoding(this.requestEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        List<FileItem> fileItems = this.parseRequest(request);
        return this.processFileItems(request, fileItems);
    }

    public void threadDidCleanup() {
        for (UploadedFileItem uploaded : this.uploads.values()) {
            uploaded.cleanup();
        }
    }

    protected List<FileItem> parseRequest(HttpServletRequest request) {
        try {
            return this.createFileUpload().parseRequest(request);
        }
        catch (FileUploadException ex) {
            this.uploadException = ex;
            return Collections.emptyList();
        }
    }

    protected ServletFileUpload createFileUpload() {
        ServletFileUpload upload = new ServletFileUpload(this.fileItemFactory);
        upload.setSizeMax(this.maxRequestSize);
        upload.setFileSizeMax(this.maxFileSize);
        return upload;
    }

    protected HttpServletRequest processFileItems(HttpServletRequest request, List<FileItem> fileItems) {
        if (this.uploadException == null && fileItems.isEmpty()) {
            return request;
        }
        ParametersServletRequestWrapper wrapper = new ParametersServletRequestWrapper(request);
        Iterator i$ = request.getParameterMap().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry e;
            Map.Entry ee = e = i$.next();
            for (String s : (String[])ee.getValue()) {
                wrapper.addParameter((String)ee.getKey(), s);
            }
        }
        for (FileItem item : fileItems) {
            if (item.isFormField()) {
                String fieldValue;
                try {
                    fieldValue = item.getString(this.requestEncoding);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
                wrapper.addParameter(item.getFieldName(), fieldValue);
                continue;
            }
            wrapper.addParameter(item.getFieldName(), item.getName());
            this.addUploadedFile(item.getFieldName(), new UploadedFileItem(item));
        }
        return wrapper;
    }

    protected void addUploadedFile(String name, UploadedFileItem file) {
        this.uploads.put(name, file);
    }

    @Override
    public FileUploadException getUploadException() {
        return this.uploadException;
    }
}

